/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.AlluxioURI;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import alluxio.stress.cli.StressMasterBench;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.master.MasterBenchBaseParameters;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.stress.master.MasterBenchTaskResultBase;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
public class MaxFileBench
extends StressMasterBench {
    private static final Logger LOG = LoggerFactory.getLogger(MaxFileBench.class);
    static AtomicBoolean sFinish = new AtomicBoolean(false);
    private final MasterBenchTaskResult mTotalResults = new MasterBenchTaskResult();
    private final List<String> mDefaultParams = Arrays.asList("--bench-timeout", String.format("%ds", Integer.MAX_VALUE), "--client-type", FileSystemClientType.ALLUXIO_NATIVE.toString(), "--cluster-start-delay", "0s", "--duration", String.format("%ds", Integer.MAX_VALUE), "--operation", Operation.CREATE_FILE.toString(), "--stop-count", Integer.toString(-1), "--warmup", "0s", "--write-type", WritePType.MUST_CACHE.toString());

    public static void main(String[] args) {
        MaxFileBench.mainInternal(args, new MaxFileBench());
    }

    @Override
    public String getBenchDescription() {
        ArrayList<String> descLines = new ArrayList<String>(Arrays.asList("MaxFile. Creates files until no more files can be created.", "This stressbench ignore the following options and sets its own values as follows:"));
        for (int i = 0; i < this.mDefaultParams.size(); i += 2) {
            descLines.add(String.format("%s=%s", this.mDefaultParams.get(i), this.mDefaultParams.get(i + 1)));
        }
        return Strings.join((String)"\n\t", descLines);
    }

    @Override
    protected void parseParameters(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        argsList.addAll(this.mDefaultParams);
        JCommander jc = new JCommander((Object)this);
        jc.setAllowParameterOverwriting(true);
        jc.setProgramName(this.getClass().getSimpleName());
        try {
            jc.parse(argsList.toArray(new String[0]));
            if (this.mBaseParameters.mHelp) {
                System.out.println(this.getBenchDescription());
                jc.usage();
                System.exit(0);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse command: ", (Throwable)e);
            System.out.println(this.getBenchDescription());
            jc.usage();
            throw e;
        }
    }

    @Override
    public MasterBenchTaskResult runLocal() throws Exception {
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"maxfile-bench-thread", (int)((MasterBenchParameters)this.mParameters).mThreads).create();
        ArrayList<AlluxioNativeMaxFileThread> callables = new ArrayList<AlluxioNativeMaxFileThread>(((MasterBenchParameters)this.mParameters).mThreads);
        for (int i = 0; i < ((MasterBenchParameters)this.mParameters).mThreads; ++i) {
            callables.add(new AlluxioNativeMaxFileThread(i, this.mCachedNativeFs[i % this.mCachedNativeFs.length]));
        }
        LOG.info("Starting {} bench threads", (Object)callables.size());
        long startMs = CommonUtils.getCurrentMs();
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        this.mTotalResults.setDurationMs(CommonUtils.getCurrentMs() - startMs);
        LOG.info("Bench threads finished");
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        return this.mTotalResults;
    }

    private final class AlluxioNativeMaxFileThread
    implements Callable<Void> {
        private static final int OPERATION_TIMEOUT_MS = 120000;
        private RetryPolicy mRetryPolicy = this.createPolicy();
        private final ExecutorService mExecutor = Executors.newSingleThreadExecutor();
        private final MasterBenchTaskResult mResult = new MasterBenchTaskResult();
        private final int mId;
        private final FileSystem mFs;
        private final Path mBasePath;
        private final Path mFixedBasePath;

        AlluxioNativeMaxFileThread(int id, FileSystem fs) {
            this.mId = id;
            this.mFs = fs;
            this.mBasePath = new Path(PathUtils.concatPath((Object)((MasterBenchParameters)MaxFileBench.this.mParameters).mBasePath, (Object[])new Object[]{"files", this.mId}));
            this.mFixedBasePath = new Path(this.mBasePath, "fixed");
            LOG.info("[{}]: basePath: {}, fixedBasePath: {}", new Object[]{this.mId, this.mBasePath, this.mFixedBasePath});
        }

        private RetryPolicy createPolicy() {
            int numAttempts = 3;
            return new CountingRetry(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            this.mResult.setRecordStartMs(CommonUtils.getCurrentMs());
            AtomicLong localCounter = new AtomicLong();
            while (!sFinish.get() && this.mRetryPolicy.attempt() && !Thread.currentThread().isInterrupted()) {
                long increment = localCounter.getAndIncrement();
                if (increment % 100000L == 0L) {
                    LOG.info("[{}] Created {} files", (Object)this.mId, (Object)increment);
                }
                try {
                    this.mExecutor.submit(() -> {
                        try {
                            this.applyOperation(increment);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }).get(120000L, TimeUnit.MILLISECONDS);
                    this.mResult.incrementNumSuccess(1L);
                    this.mRetryPolicy = this.createPolicy();
                }
                catch (Exception e) {
                    LOG.info("[{}] Attempt #{} failed: {}", new Object[]{this.mId, this.mRetryPolicy.getAttemptCount(), e});
                }
            }
            sFinish.set(true);
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            this.mResult.setParameters((MasterBenchBaseParameters)((MasterBenchParameters)MaxFileBench.this.mParameters));
            this.mResult.setBaseParameters(MaxFileBench.this.mBaseParameters);
            LOG.info("[{}] numSuccesses = {}", (Object)this.mId, (Object)this.mResult.getStatistics().mNumSuccesses);
            MasterBenchTaskResult masterBenchTaskResult = MaxFileBench.this.mTotalResults;
            synchronized (masterBenchTaskResult) {
                MaxFileBench.this.mTotalResults.merge((MasterBenchTaskResultBase)this.mResult);
            }
            return null;
        }

        private void applyOperation(long counter) throws IOException, AlluxioException {
            Path path = counter < (long)((MasterBenchParameters)MaxFileBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
            this.mFs.createFile(new AlluxioURI(path.toString()), CreateFilePOptions.newBuilder().setRecursive(true).build());
        }
    }
}

