/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.job.util.SerializationUtils;
import alluxio.stress.Parameters;
import alluxio.stress.cli.StressJobServiceBench;
import alluxio.stress.cli.suite.AbstractMaxThroughput;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.jobservice.JobServiceBenchParameters;
import alluxio.stress.jobservice.JobServiceBenchSummary;
import alluxio.stress.jobservice.JobServiceBenchTaskResult;
import alluxio.stress.jobservice.JobServiceMaxThroughputSummary;
import alluxio.util.JsonSerializable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class JobServiceMaxThroughput
extends AbstractMaxThroughput<JobServiceBenchTaskResult, JobServiceMaxThroughputSummary, GeneralBenchSummary<JobServiceBenchTaskResult>, JobServiceBenchParameters> {
    public static void main(String[] args) {
        JobServiceMaxThroughput.mainInternal(args, new JobServiceMaxThroughput());
    }

    private JobServiceMaxThroughput() {
    }

    @Override
    public void initParameters(List<String> baseArgs) {
        this.mParameters = new JobServiceBenchParameters();
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"", (Object)"A benchmarking tool to measure the job service max throughput of Alluxio.", (Object)"Example:", (Object)"# this would continuously run `CreateFiles` opeartion and record the throughput.", (Object)"$ bin/alluxio runClass alluxio.stress.cli.suite.JobServiceMaxThroughput --operation Noop", (Object)""));
    }

    @Override
    protected JobServiceBenchSummary runSingleTest(List<String> args, int targetThroughput) throws Exception {
        StressJobServiceBench b = new StressJobServiceBench();
        String result = b.run(args.toArray(new String[0]));
        return (JobServiceBenchSummary)JsonSerializable.fromJson((String)SerializationUtils.parseBenchmarkResult((String)result), (JsonSerializable[])new JobServiceBenchSummary[0]);
    }

    @Override
    public void prepare() {
        this.mMaxThroughputResult = new JobServiceMaxThroughputSummary();
        ((JobServiceMaxThroughputSummary)this.mMaxThroughputResult).setParameters((Parameters)((JobServiceBenchParameters)this.mParameters));
        this.mInitialThroughput = ((JobServiceBenchParameters)this.mParameters).mTargetThroughput;
    }
}

