/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.AlluxioURI;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.stress.cli.StressMasterBenchBase;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.master.MasterBenchBaseParameters;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.MultiOperationMasterBenchParameters;
import alluxio.stress.master.MultiOperationMasterBenchTaskResult;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.io.PathUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.HdrHistogram.Histogram;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOperationStressMasterBench
extends StressMasterBenchBase<MultiOperationMasterBenchTaskResult, MultiOperationMasterBenchParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiOperationStressMasterBench.class);

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public MultiOperationStressMasterBench() {
        super(new MultiOperationMasterBenchParameters());
    }

    public static void main(String[] args) {
        MultiOperationStressMasterBench.mainInternal(args, new MultiOperationStressMasterBench());
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A benchmarking tool to measure the master performance of Alluxio", (Object)"This benchmark is a variant of StressMasterBench, where a user can specify multiple ", (Object)"operations to run concurrently with some constraints to limit the throughput of ", (Object)"each operations.", (Object)"", (Object)"Example:", (Object)"# this would continuously run `GetFileStatus` and CreateFile for 30s and record the throughput after 5s warmup. The CreateFile throughput will be 4x more than GetFileStatus.", (Object)"$ bin/alluxio runClass alluxio.stress.cli.MultiOperationStressMasterBench \\", (Object)"--operations GetFileStatus,CreateFile --operations-ratio 1,4  --fixed-counts 100,1 \\", (Object)"--warmup 1s  --duration 10s -client-type AlluxioNative --threads 16 ", (Object)"", (Object)"Use the following command to prepare the test directory to list with before running test:", (Object[])new String[]{"$ bin/alluxio runClass alluxio.stress.cli.StressMasterBench \\", "--base alluxio:///stress-master-base-0 --fixed-count 100 --stop-count 100 --warmup 5s \\", "--operation CreateFile --duration 30s --client-type AlluxioNative"}));
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void validateParams() throws Exception {
        int numOperations = ((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length;
        if (numOperations < 2) {
            throw new InvalidArgumentException(String.format("%s operations must contain at least two operations.", "--operations"));
        }
        if (((MultiOperationMasterBenchParameters)this.mParameters).mBasePaths.length != ((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length) {
            throw new InvalidArgumentException(String.format("%s must contain the same number of params as %s .", "--bases", "--operations"));
        }
        InvalidArgumentException duplicatedModeSpecifiedException = new InvalidArgumentException(String.format("Exact one of the following params %s, %s, %s must be specified", "--target-throughputs", "--threads-ratio", "--operations-ratio"));
        boolean modeSpecified = false;
        if (((MultiOperationMasterBenchParameters)this.mParameters).mTargetThroughputs != null) {
            if (((MultiOperationMasterBenchParameters)this.mParameters).mTargetThroughputs.length != numOperations) {
                throw new InvalidArgumentException(String.format("If specified, %s must contain the same number of args as %s.", "--target-throughputs", "--operations"));
            }
            modeSpecified = true;
        }
        if (((MultiOperationMasterBenchParameters)this.mParameters).mThreadsRatio != null) {
            if (((MultiOperationMasterBenchParameters)this.mParameters).mThreadsRatio.length != numOperations) {
                throw new InvalidArgumentException(String.format("If specified, %s must contain the same number of args as %s.", "--threads-ratio", "--operations"));
            }
            if (modeSpecified) {
                throw duplicatedModeSpecifiedException;
            }
            modeSpecified = true;
        }
        if (((MultiOperationMasterBenchParameters)this.mParameters).mOperationsRatio != null) {
            if (((MultiOperationMasterBenchParameters)this.mParameters).mOperationsRatio.length != numOperations) {
                throw new InvalidArgumentException(String.format("If specified, %s must contain the same number of args as %s.", "--operations-ratio", "--operations"));
            }
            if (modeSpecified) {
                throw duplicatedModeSpecifiedException;
            }
            modeSpecified = true;
        }
        if (!modeSpecified) {
            throw duplicatedModeSpecifiedException;
        }
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void prepare() throws Exception {
        int i;
        if (!this.mBaseParameters.mDistributed) {
            Configuration hdfsConf = new Configuration();
            hdfsConf.set("alluxio.user.file.delete.unchecked", "true");
            hdfsConf.set("alluxio.user.file.writetype.default", ((MultiOperationMasterBenchParameters)this.mParameters).mWriteType);
            hdfsConf.set("alluxio.user.file.master.client.pool.size.max", "256");
            FileSystem prepareFs = FileSystem.get((URI)new URI(((MultiOperationMasterBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
            for (int i2 = 0; i2 < ((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length; ++i2) {
                Operation op = ((MultiOperationMasterBenchParameters)this.mParameters).mOperations[i2];
                Path path = new Path(((MultiOperationMasterBenchParameters)this.mParameters).mBasePaths[i2]);
                Path basePath = op == Operation.CREATE_DIR ? new Path(path, "dirs") : new Path(path, "files");
                if (!((MultiOperationMasterBenchParameters)this.mParameters).mSkipPrepare) {
                    if (op == Operation.CREATE_FILE || op == Operation.CREATE_DIR) {
                        LOG.info("Cleaning base path: {}", (Object)basePath);
                        long start = CommonUtils.getCurrentMs();
                        this.deletePaths(prepareFs, basePath);
                        long end = CommonUtils.getCurrentMs();
                        LOG.info("Cleanup took: {} s", (Object)((double)(end - start) / 1000.0));
                        prepareFs.mkdirs(basePath);
                    } else if (!prepareFs.exists(basePath)) {
                        throw new IllegalStateException(String.format("base path (%s) must exist for operation (%s)", basePath, op));
                    }
                }
                if (prepareFs.isDirectory(basePath)) continue;
                throw new IllegalStateException(String.format("base path (%s) must be a directory for operation (%s)", basePath, op));
            }
        }
        if (((MultiOperationMasterBenchParameters)this.mParameters).mClientType == FileSystemClientType.ALLUXIO_HDFS) {
            throw new RuntimeException("ALLUXIO HDFS Compatible API is not support for multi operations stress master bench");
        }
        LOG.info("Using ALLUXIO Native API to perform the test.");
        InstancedConfiguration alluxioProperties = alluxio.conf.Configuration.copyGlobal();
        alluxioProperties.set(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)((MultiOperationMasterBenchParameters)this.mParameters).mWriteType, Source.RUNTIME);
        this.mCachedNativeFs = new alluxio.client.file.FileSystem[((MultiOperationMasterBenchParameters)this.mParameters).mClients];
        for (i = 0; i < this.mCachedNativeFs.length; ++i) {
            this.mCachedNativeFs[i] = FileSystem.Factory.create((AlluxioConfiguration)alluxioProperties);
        }
        for (i = 0; i < ((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length; ++i) {
            if (((MultiOperationMasterBenchParameters)this.mParameters).mOperations[i] != Operation.CRURD && ((MultiOperationMasterBenchParameters)this.mParameters).mOperations[i] != Operation.CREATE_DELETE_FILE) continue;
            AlluxioURI uri = new AlluxioURI(PathUtils.concatPath((Object)((MultiOperationMasterBenchParameters)this.mParameters).mBasePaths[i], (Object[])new Object[]{"files", this.mBaseParameters.mId}));
            if (this.mCachedNativeFs[0].exists(uri)) {
                this.mCachedNativeFs[0].delete(uri, DeletePOptions.newBuilder().setRecursive(true).build());
            }
            this.mCachedNativeFs[0].createDirectory(uri, CreateDirectoryPOptions.getDefaultInstance());
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected BenchThread getBenchThread(StressMasterBenchBase.BenchContext context, int index) {
        if (((MultiOperationMasterBenchParameters)this.mParameters).mClientType == FileSystemClientType.ALLUXIO_NATIVE) {
            return new AlluxioNativeBenchThread(context, this.mCachedNativeFs[index % this.mCachedNativeFs.length], index);
        }
        throw new RuntimeException("ALLUXIO HDFS and POSIX API is not support for multi operations stress master bench");
    }

    private RateLimiter createUnlimitedRateLimiter() {
        return RateLimiter.create((double)Double.MAX_VALUE);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected StressMasterBenchBase.BenchContext getContext() throws IOException, AlluxioException {
        StressMasterBenchBase.BenchContext benchContext;
        if (((MultiOperationMasterBenchParameters)this.mParameters).mTargetThroughputs == null) {
            RateLimiter[] rateLimiters = new RateLimiter[((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length];
            for (int i = 0; i < ((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length; ++i) {
                rateLimiters[i] = this.createUnlimitedRateLimiter();
            }
            benchContext = new StressMasterBenchBase.BenchContext(this, this.createUnlimitedRateLimiter(), rateLimiters, ((MultiOperationMasterBenchParameters)this.mParameters).mOperations, ((MultiOperationMasterBenchParameters)this.mParameters).mBasePaths, ((MultiOperationMasterBenchParameters)this.mParameters).mDuration);
        } else {
            int sum = 0;
            RateLimiter[] rateLimiters = new RateLimiter[((MultiOperationMasterBenchParameters)this.mParameters).mOperations.length];
            for (int i = 0; i < ((MultiOperationMasterBenchParameters)this.mParameters).mTargetThroughputs.length; ++i) {
                rateLimiters[i] = RateLimiter.create((double)((MultiOperationMasterBenchParameters)this.mParameters).mTargetThroughputs[i]);
                sum += ((MultiOperationMasterBenchParameters)this.mParameters).mTargetThroughputs[i];
            }
            benchContext = new StressMasterBenchBase.BenchContext(this, RateLimiter.create((double)sum), rateLimiters, ((MultiOperationMasterBenchParameters)this.mParameters).mOperations, ((MultiOperationMasterBenchParameters)this.mParameters).mBasePaths, ((MultiOperationMasterBenchParameters)this.mParameters).mDuration);
        }
        return benchContext;
    }

    private final class AlluxioNativeBenchThread
    extends BenchThread {
        private final alluxio.client.file.FileSystem mFs;

        private AlluxioNativeBenchThread(StressMasterBenchBase.BenchContext context, alluxio.client.file.FileSystem fs, int threadIndex) {
            super(context, threadIndex);
            this.mFs = fs;
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        protected void applyOperation(int operationIndex, long operationCounter) throws IOException, AlluxioException {
            MultiOperationStressMasterBench.this.applyNativeOperation(this.mFs, ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations[operationIndex], operationCounter, this.mBasePaths[operationIndex], this.mFixedBasePaths[operationIndex], ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mFixedCounts[operationIndex]);
        }
    }

    protected abstract class BenchThread
    implements Callable<Void> {
        private final StressMasterBenchBase.BenchContext mContext;
        private final Histogram[] mResponseTimeNs;
        protected final Path[] mBasePaths;
        protected final Path[] mFixedBasePaths;
        private final MultiOperationMasterBenchTaskResult mResult;
        private final int mThreadIndex;
        private final Random mRandom = new Random();

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private BenchThread(StressMasterBenchBase.BenchContext context, int threadIndex) {
            this.mContext = context;
            this.mResponseTimeNs = new Histogram[((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length];
            this.mBasePaths = this.mContext.getBasePaths();
            this.mFixedBasePaths = this.mContext.getFixedPaths();
            this.mResult = new MultiOperationMasterBenchTaskResult(((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations);
            for (int i = 0; i < ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length; ++i) {
                this.mResponseTimeNs[i] = new Histogram(1800000000000L, 3);
            }
            this.mThreadIndex = threadIndex;
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public Void call() {
            try {
                if (((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperationsRatio != null) {
                    this.runOperationsRatioBased();
                } else if (((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mThreadsRatio != null) {
                    this.runThreadsRatioBased();
                } else {
                    this.runInternalTargetThroughputBased();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn("Exception during bench thread runInternal", (Throwable)e);
                this.mResult.addErrorMessage(e.getMessage());
            }
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            List statistics = this.mResult.getAllStatistics();
            for (int i = 0; i < statistics.size(); ++i) {
                ((MasterBenchTaskResultStatistics)statistics.get(i)).encodeResponseTimeNsRaw(this.mResponseTimeNs[i]);
            }
            this.mResult.setParameters((MasterBenchBaseParameters)MultiOperationStressMasterBench.this.mParameters);
            this.mResult.setBaseParameters(MultiOperationStressMasterBench.this.mBaseParameters);
            this.mContext.mergeThreadResult(this.mResult);
            return null;
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private void runInternal(Function<Integer, Integer> operationIndexSelector) throws Exception {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mWarmup);
            this.mResult.setRecordStartMs(recordMs);
            boolean useStopCount = ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mStopCount != -1;
            long bucketSize = (this.mContext.getEndMs() - recordMs) / 20L;
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Increase the start delay. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            int operationIndex = 0;
            while (!Thread.currentThread().isInterrupted() && (useStopCount || CommonUtils.getCurrentMs() < this.mContext.getEndMs())) {
                long totalCounter = this.mContext.getTotalCounter().incrementAndGet() - 1L;
                if (useStopCount && totalCounter >= (long)((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mStopCount) break;
                operationIndex = operationIndexSelector.apply(operationIndex);
                long operationCount = this.mContext.getOperationCounter(operationIndex).incrementAndGet() - 1L;
                long startNs = System.nanoTime();
                this.applyOperation(operationIndex, operationCount);
                long endNs = System.nanoTime();
                long currentMs = CommonUtils.getCurrentMs();
                if (currentMs <= recordMs) continue;
                this.mResult.incrementNumSuccess(operationIndex, 1L);
                long responseTimeNs = endNs - startNs;
                this.mResponseTimeNs[operationIndex].recordValue(responseTimeNs);
                long[] maxResponseTimeNs = this.mResult.getStatistics((int)operationIndex).mMaxResponseTimeNs;
                int bucket = Math.min(maxResponseTimeNs.length - 1, (int)((currentMs - recordMs) / bucketSize));
                if (responseTimeNs <= maxResponseTimeNs[bucket]) continue;
                maxResponseTimeNs[bucket] = responseTimeNs;
            }
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private double[] getProbabilityDistribution(double[] ratios) {
            int i;
            double ratioSum = 0.0;
            double last = 0.0;
            double[] probabilities = new double[ratios.length];
            for (i = 0; i < ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length; ++i) {
                ratioSum += ratios[i];
            }
            for (i = 0; i < ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length; ++i) {
                probabilities[i] = last + ratios[i] / ratioSum;
                last = probabilities[i];
            }
            return probabilities;
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private void runOperationsRatioBased() throws Exception {
            double[] probabilities = this.getProbabilityDistribution(((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperationsRatio);
            this.runInternal(lastOperationIndex -> {
                double r = this.mRandom.nextDouble();
                int operationIndex = 0;
                for (int i = 0; i < ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length; ++i) {
                    if (!(probabilities[i] >= r)) continue;
                    operationIndex = i;
                    break;
                }
                this.mContext.getRateLimiter(0).acquire();
                return operationIndex;
            });
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private void runThreadsRatioBased() throws Exception {
            double[] probabilities = this.getProbabilityDistribution(((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mThreadsRatio);
            int operationIndex = 0;
            for (int i = 0; i < ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length; ++i) {
                if (!(probabilities[i] > (double)this.mThreadIndex / (double)((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mThreads)) continue;
                operationIndex = i;
                break;
            }
            int finalOperationIndex = operationIndex;
            this.runInternal(lastOperationIndex -> {
                this.mContext.getRateLimiter(finalOperationIndex).acquire();
                return finalOperationIndex;
            });
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private void runInternalTargetThroughputBased() throws Exception {
            RateLimiter[] rls = this.mContext.getRateLimiters();
            this.runInternal(lastOperationIndex -> {
                int operationIndex = (lastOperationIndex + 1) % ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length;
                this.mContext.getGrandRateLimiter().acquire();
                while (!rls[operationIndex].tryAcquire()) {
                    ++operationIndex;
                    operationIndex %= ((MultiOperationMasterBenchParameters)MultiOperationStressMasterBench.this.mParameters).mOperations.length;
                }
                return operationIndex;
            });
        }

        protected abstract void applyOperation(int var1, long var2) throws IOException, AlluxioException;
    }
}

