/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.stress.TaskResult;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.common.FileSystemParameters;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStressBench<T extends TaskResult, P extends FileSystemParameters>
extends Benchmark<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStressBench.class);
    @ParametersDelegate
    protected P mParameters;

    public abstract void validateParams() throws Exception;

    @Override
    public String run(String[] args) throws Exception {
        this.parseParameters(args);
        this.validateParams();
        if (((FileSystemParameters)this.mParameters).mWriteType.equals("ALL")) {
            ImmutableList writeTypes = ImmutableList.of((Object)"MUST_CACHE", (Object)"CACHE_THROUGH", (Object)"ASYNC_THROUGH", (Object)"THROUGH");
            System.out.format("Now executing %s with all possible write types %s %n", this.getClass().toString(), writeTypes);
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("--write-type")) continue;
                Iterator iterator = writeTypes.iterator();
                while (iterator.hasNext()) {
                    String type;
                    args[i + 1] = type = (String)iterator.next();
                    ((FileSystemParameters)this.mParameters).mWriteType = type;
                    System.out.println("-----------------------------------------------------");
                    System.out.format("Now executing write type %s... %n", type);
                    try {
                        String result = this.runSingleTask(args);
                        System.out.println(result);
                    }
                    catch (Exception e) {
                        System.out.format("Exception occurred when executing parameter --write-type %s %n", type);
                        System.out.println(e.getMessage());
                    }
                }
                System.out.println("-----------------------------------------------------");
                return "All tasks finished. You can find the test results in the outputs above.";
            }
        }
        return this.runSingleTask(args);
    }
}

