/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.worker;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.membership.WorkerClusterView;
import alluxio.stress.cli.AbstractStressBench;
import alluxio.stress.worker.WorkerBenchCoarseDataPoint;
import alluxio.stress.worker.WorkerBenchDataPoint;
import alluxio.stress.worker.WorkerBenchParameters;
import alluxio.stress.worker.WorkerBenchTaskResult;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.logging.SamplingLogger;
import alluxio.wire.WorkerInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="There is a downcast from FileSystemParameters to WorkerBenchParameters in the generic")
public class StressWorkerBench
extends AbstractStressBench<WorkerBenchTaskResult, WorkerBenchParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(StressWorkerBench.class);
    private static final Logger SAMPLING_LOG = new SamplingLogger(LoggerFactory.getLogger(StressWorkerBench.class), 10000L);
    private static final long DUMMY_BLOCK_SIZE = 0x4000000L;
    private FileSystem[] mCachedFs;
    private Path[] mFilePaths;
    private FileSystemContext mFsContext;

    private long randomNumInRange(long min, long max) {
        return ThreadLocalRandom.current().nextLong(min, max + 1L) + min;
    }

    private long minLong(long a, long b) {
        return a > b ? a : b;
    }

    public StressWorkerBench() {
        this.mParameters = new WorkerBenchParameters();
        this.mFsContext = FileSystemContext.create();
    }

    private int getTotalFileNumber() {
        int clusterSize = this.mBaseParameters.mClusterLimit;
        int threads = ((WorkerBenchParameters)this.mParameters).mThreads;
        int numFiles = clusterSize * threads;
        LOG.info("Total {} * {} = {} files will be generated", new Object[]{clusterSize, threads, numFiles});
        return numFiles;
    }

    private Path calculateFilePath(Path base, int workerIdx, int threadIdx) {
        return new Path(base, "worker-" + workerIdx + "-thread-" + threadIdx);
    }

    public static void main(String[] args) {
        StressWorkerBench.mainInternal(args, new StressWorkerBench());
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A benchmarking tool to measure the read performance of alluxio workers in the cluster", (Object)"The test will run with multiple threads and perform concurrent I/O. One file will ", (Object)"be prepared for each thread that thread will read that one file repeatedly until ", (Object)"the specified duration has elapsed.", (Object)"", (Object)"Example:", (Object)"# The command below spawn 32 test threads per worker in your cluster. One 100MB file willbe prepared for each test thread.# The threads will keeping reading for 30s including a 10s warmup.# So the result captures I/O performance from the last 20s.", (Object)"$ bin/alluxio exec class alluxio.stress.cli.worker.StressWorkerBench -- \\\n--threads 32 --base alluxio:///stress-worker-base --file-size 100m \\\n--warmup 10s --duration 30s --cluster\n"));
    }

    @Override
    public void prepare() throws Exception {
        Configuration hdfsConf;
        this.validateParams();
        if (this.mBaseParameters.mClusterLimit == 0) {
            this.mBaseParameters.mClusterLimit = this.mFsContext.getCachedWorkers().size();
            LOG.info("No --cluster-limit was set, use all {} workers in the cluster", (Object)this.mBaseParameters.mClusterLimit);
        }
        if (this.mBaseParameters.mStartMs == -1L) {
            LOG.info("Start time is unspecified, leaving 5s for preparation");
            this.mBaseParameters.mStartMs = CommonUtils.getCurrentMs() + 5000L;
        }
        Path basePath = new Path(((WorkerBenchParameters)this.mParameters).mBasePath);
        long fileSize = FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)this.mParameters).mFileSize);
        int numFiles = this.getTotalFileNumber();
        this.mFilePaths = new Path[numFiles];
        this.generateTestFilePaths(basePath);
        if (this.mBaseParameters.mDistributed) {
            LOG.info("Running in distributed mode on a job worker. The test file should have been prepared in the commandline process before distributing the tasks.");
        } else if (((WorkerBenchParameters)this.mParameters).mSkipCreation) {
            LOG.info("Test file preparation is skipped");
        } else {
            LOG.info("Preparing the test files in the command line");
            hdfsConf = new Configuration();
            hdfsConf.set("alluxio.user.file.delete.unchecked", "true");
            hdfsConf.set("alluxio.user.file.writetype.default", ((WorkerBenchParameters)this.mParameters).mWriteType);
            FileSystem prepareFs = FileSystem.get((URI)new URI(((WorkerBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
            this.prepareTestFiles(basePath, fileSize, prepareFs);
        }
        hdfsConf = new Configuration();
        hdfsConf.set(String.format("fs.%s.impl.disable.cache", new URI(((WorkerBenchParameters)this.mParameters).mBasePath).getScheme()), "true");
        switch (((WorkerBenchParameters)this.mParameters).mMode) {
            case CONSISTENT: {
                hdfsConf.set("alluxio.user.worker.selection.policy", "CONSISTENT");
                break;
            }
            case JUMP: {
                hdfsConf.set("alluxio.user.worker.selection.policy", "JUMP");
                break;
            }
            case KETAMA: {
                hdfsConf.set("alluxio.user.worker.selection.policy", "KETAMA");
                break;
            }
            case MAGLEV: {
                hdfsConf.set("alluxio.user.worker.selection.policy", "MAGLEV");
                break;
            }
            case MULTI_PROBE: {
                hdfsConf.set("alluxio.user.worker.selection.policy", "MULTI_PROBE");
                break;
            }
            case LOCAL_ONLY: {
                hdfsConf.set("alluxio.user.worker.selection.policy", "LOCAL");
                break;
            }
            case REMOTE_ONLY: {
                if (this.mBaseParameters.mClusterLimit == 1) {
                    throw new IllegalArgumentException("Cluster size is 1. REMOTE_ONLY mode not supported.");
                }
                hdfsConf.set("alluxio.user.worker.selection.policy", "REMOTE");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mode" + ((WorkerBenchParameters)this.mParameters).mMode);
            }
        }
        LOG.info("User worker selection policy: {}", (Object)((WorkerBenchParameters)this.mParameters).mMode);
        for (Map.Entry entry : ((WorkerBenchParameters)this.mParameters).mConf.entrySet()) {
            hdfsConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        LOG.info("HDFS config used in the test: {}", (Object)hdfsConf);
        this.mCachedFs = new FileSystem[((WorkerBenchParameters)this.mParameters).mClients];
        for (int i = 0; i < this.mCachedFs.length; ++i) {
            this.mCachedFs[i] = FileSystem.get((URI)new URI(((WorkerBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
        }
    }

    public void generateTestFilePaths(Path basePath) throws IOException {
        int clusterSize = this.mBaseParameters.mClusterLimit;
        int threads = ((WorkerBenchParameters)this.mParameters).mThreads;
        WorkerClusterView workerClusterView = this.mFsContext.getCachedWorkers();
        List workers = workerClusterView.stream().collect(Collectors.toList());
        for (int i = 0; i < clusterSize; ++i) {
            WorkerInfo localWorker = (WorkerInfo)workers.get(i);
            LOG.info("Building file paths for worker {}", (Object)localWorker);
            for (int j = 0; j < threads; ++j) {
                Path filePath = this.calculateFilePath(basePath, i, j);
                int index = i * threads + j;
                this.mFilePaths[index] = filePath;
            }
        }
        LOG.info("{} file paths generated", (Object)this.mFilePaths.length);
    }

    private void prepareTestFiles(Path basePath, long fileSize, FileSystem prepareFs) throws IOException {
        int numFiles = this.mFilePaths.length;
        LOG.info("Preparing {} test files under {}", (Object)numFiles, (Object)basePath);
        if (prepareFs.exists(basePath)) {
            LOG.info("The base path exists, delete it first.");
            prepareFs.delete(basePath, true);
        }
        LOG.info("Creating the new base path directory");
        prepareFs.mkdirs(basePath);
        LOG.info("Empty base path directory created");
        byte[] buffer = new byte[(int)FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)this.mParameters).mBufferSize)];
        Arrays.fill(buffer, (byte)65);
        LOG.info("Creating {} files...", (Object)numFiles);
        block9: for (int i = 0; i < numFiles; ++i) {
            if (i > 0 && i % 1000 == 0) {
                LOG.info("{} files created", (Object)i);
            }
            Path filePath = this.mFilePaths[i];
            LOG.info("Creating file {}", (Object)filePath);
            try (FSDataOutputStream mOutStream = prepareFs.create(filePath, false, buffer.length, (short)1, 0x4000000L);){
                while (true) {
                    int bytesToWrite;
                    if ((bytesToWrite = (int)Math.min(fileSize - mOutStream.getPos(), (long)buffer.length)) == 0) {
                        continue block9;
                    }
                    mOutStream.write(buffer, 0, bytesToWrite);
                }
            }
        }
        LOG.info("All test files created");
    }

    @Override
    public WorkerBenchTaskResult runLocal() throws Exception {
        Preconditions.checkArgument((this.mBaseParameters.mStartMs >= 0L ? 1 : 0) != 0, (Object)"startMs was not specified correctly!");
        Preconditions.checkArgument((this.mBaseParameters.mClusterLimit > 0 ? 1 : 0) != 0, (Object)"clusterLimit was not specified correctly!");
        LOG.info("Worker ID is {}, index is {}", (Object)this.mBaseParameters.mId, (Object)this.mBaseParameters.mIndex);
        LOG.info("This test will use {} workers in the cluster", (Object)this.mBaseParameters.mClusterLimit);
        int startFileIndex = 0;
        int endFileIndex = this.getTotalFileNumber();
        if (this.mBaseParameters.mIndex.equals("local-task-0")) {
            LOG.info("This is running in the command line process. Read all {} files with {} threads.", (Object)endFileIndex, (Object)((WorkerBenchParameters)this.mParameters).mThreads);
        } else {
            LOG.info("This job worker has index {} among {} workers", (Object)this.mBaseParameters.mIndex, (Object)this.mBaseParameters.mClusterLimit);
            int threadNum = ((WorkerBenchParameters)this.mParameters).mThreads;
            int workerIndex = Integer.parseInt(this.mBaseParameters.mIndex);
            startFileIndex = workerIndex * threadNum;
            endFileIndex = startFileIndex + threadNum;
            LOG.info("This job worker threads read files [{}, {})", (Object)startFileIndex, (Object)endFileIndex);
        }
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)((WorkerBenchParameters)this.mParameters).mThreads).create();
        long durationMs = FormatUtils.parseTimeSize((String)((WorkerBenchParameters)this.mParameters).mDuration);
        long warmupMs = FormatUtils.parseTimeSize((String)((WorkerBenchParameters)this.mParameters).mWarmup);
        long startMs = this.mBaseParameters.mStartMs;
        long endMs = startMs + warmupMs + durationMs;
        String datePattern = alluxio.conf.Configuration.global().getString(PropertyKey.USER_DATE_FORMAT_PATTERN);
        SAMPLING_LOG.info("StressWorkerBench has start={}, warmup={}ms, end={}", new Object[]{CommonUtils.convertMsToDate((long)startMs, (String)datePattern), warmupMs, CommonUtils.convertMsToDate((long)endMs, (String)datePattern)});
        BenchContext context = new BenchContext(startMs, endMs);
        ArrayList<BenchThread> callables = new ArrayList<BenchThread>(((WorkerBenchParameters)this.mParameters).mThreads);
        for (int threadIndex = 0; threadIndex < ((WorkerBenchParameters)this.mParameters).mThreads; ++threadIndex) {
            int fileIndex = startFileIndex + threadIndex;
            LOG.info("Thread {} reads file {} path {}", new Object[]{threadIndex, fileIndex, this.mFilePaths[fileIndex]});
            callables.add(new BenchThread(context, fileIndex, this.mCachedFs[threadIndex % this.mCachedFs.length]));
        }
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        return context.getResult();
    }

    @Override
    public void validateParams() throws Exception {
        WorkerClusterView workers = this.mFsContext.getCachedWorkers();
        LOG.info("Available workers in the cluster are {}", (Object)workers);
        if (this.mBaseParameters.mClusterLimit < 0) {
            throw new IllegalStateException("--cluster-limit cannot be " + this.mBaseParameters.mClusterLimit + " in StressWorkerBench. It should be a positive number. 0 means running on all workers in the cluster.");
        }
        if (this.mBaseParameters.mClusterLimit > workers.size()) {
            throw new IllegalStateException(String.format("Specified --cluster-limit %d but only have %d workers in the cluster!", this.mBaseParameters.mClusterLimit, workers.size()));
        }
        if (((WorkerBenchParameters)this.mParameters).mThreads <= 0) {
            throw new IllegalStateException("Thread number cannot be " + ((WorkerBenchParameters)this.mParameters).mThreads + " in StressWorkerBench. It should be a positive number.");
        }
        if (((WorkerBenchParameters)this.mParameters).mFree && WritePType.MUST_CACHE.name().equals(((WorkerBenchParameters)this.mParameters).mWriteType)) {
            throw new IllegalStateException(String.format("%s cannot be %s when %s option provided", "--write-type", WritePType.MUST_CACHE, "--free"));
        }
        if (FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)this.mParameters).mRandomMaxReadLength) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("mRandomReadMaxLength cannot be larger than 2.1G");
        }
        if (FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)this.mParameters).mRandomMaxReadLength) < FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)this.mParameters).mRandomMinReadLength)) {
            throw new IllegalArgumentException("mRandomReadMinLength must not larger than mRandomReadMaxLength");
        }
    }

    private final class BenchThread
    implements Callable<Void> {
        private final BenchContext mContext;
        private final int mTargetFileIndex;
        private final FileSystem mFs;
        private final byte[] mBuffer;
        private final WorkerBenchTaskResult mResult;
        private final boolean mIsRandomRead;
        private final long mRandomMax;
        private final long mRandomMin;
        private final long mFileSize;
        private FSDataInputStream mInStream;

        private BenchThread(BenchContext context, int targetFileIndex, FileSystem fs) {
            this.mContext = context;
            this.mTargetFileIndex = targetFileIndex;
            this.mFs = fs;
            this.mBuffer = new byte[(int)FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mBufferSize)];
            this.mResult = new WorkerBenchTaskResult();
            this.mResult.setParameters((WorkerBenchParameters)StressWorkerBench.this.mParameters);
            this.mResult.setBaseParameters(StressWorkerBench.this.mBaseParameters);
            this.mIsRandomRead = ((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mIsRandom;
            this.mRandomMin = FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mRandomMinReadLength);
            this.mRandomMax = FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mRandomMaxReadLength);
            this.mFileSize = FormatUtils.parseSpaceSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mFileSize);
        }

        @Override
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                LOG.error(Thread.currentThread().getName() + ": failed", (Throwable)e);
                this.mResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.closeInStream();
            }
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            this.mContext.mergeThreadResult(this.mResult);
            return null;
        }

        private void runInternal() throws Exception {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mWarmup);
            this.mResult.setRecordStartMs(recordMs);
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Increase the start delay. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            String dateFormat = alluxio.conf.Configuration.global().getString(PropertyKey.USER_DATE_FORMAT_PATTERN);
            SAMPLING_LOG.info("Scheduled to start at {}, wait {}ms for the scheduled start", (Object)CommonUtils.convertMsToDate((long)this.mContext.getStartMs(), (String)dateFormat), (Object)waitMs);
            CommonUtils.sleepMs((long)waitMs);
            SAMPLING_LOG.info("Test started and recording will be started after the warm up at {}", (Object)CommonUtils.convertMsToDate((long)recordMs, (String)dateFormat));
            String workerID = ((StressWorkerBench)StressWorkerBench.this).mBaseParameters.mIndex;
            int lastDashIndex = workerID.lastIndexOf("-");
            if (lastDashIndex != -1) {
                workerID = this.toString().substring(lastDashIndex + 1);
            }
            WorkerBenchCoarseDataPoint dp = new WorkerBenchCoarseDataPoint(Long.valueOf(Long.parseLong(workerID)), Long.valueOf(Thread.currentThread().getId()));
            WorkerBenchDataPoint slice = new WorkerBenchDataPoint();
            ArrayList<Long> throughputList = new ArrayList<Long>();
            long lastSlice = 0L;
            while (!Thread.currentThread().isInterrupted() && CommonUtils.getCurrentMs() < this.mContext.getEndMs()) {
                long startMs = CommonUtils.getCurrentMs() - recordMs;
                ApplyOperationOutput output = this.applyOperation();
                if (startMs > 0L) {
                    if (output.mBytesRead > 0L) {
                        this.mResult.setIOBytes(this.mResult.getIOBytes() + output.mBytesRead);
                        ++slice.mCount;
                        slice.mIOBytes += output.mBytesRead;
                        if (output.mDuration > 0L) {
                            throughputList.add(output.mBytesRead * 1000000000L / (0x100000L * output.mDuration));
                        } else if (output.mDuration == 0L) {
                            throughputList.add(output.mBytesRead * 1000000000L / 0x100000L);
                            SAMPLING_LOG.warn("Thread for file {} read operation finished in 0ns", (Object)StressWorkerBench.this.mFilePaths[this.mTargetFileIndex]);
                        } else {
                            throw new IllegalStateException(String.format("Negative duration for file read: %d", output.mDuration));
                        }
                        int currentSlice = (int)(startMs / FormatUtils.parseTimeSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mSliceSize));
                        while ((long)currentSlice > lastSlice) {
                            dp.addDataPoint(slice);
                            slice = new WorkerBenchDataPoint();
                            ++lastSlice;
                        }
                        continue;
                    }
                    LOG.warn("Thread for file {} read 0 bytes from I/O", (Object)StressWorkerBench.this.mFilePaths[this.mTargetFileIndex]);
                    continue;
                }
                SAMPLING_LOG.info("Ignored record during warmup: {} bytes", (Object)output.mBytesRead);
            }
            int finalSlice = (int)(FormatUtils.parseTimeSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mDuration) / FormatUtils.parseTimeSize((String)((WorkerBenchParameters)((StressWorkerBench)StressWorkerBench.this).mParameters).mSliceSize));
            while ((long)finalSlice > lastSlice) {
                dp.addDataPoint(slice);
                slice = new WorkerBenchDataPoint();
                ++lastSlice;
            }
            dp.setThroughput(throughputList);
            this.mResult.addDataPoint(dp);
        }

        private ApplyOperationOutput applyOperation() throws IOException {
            Path filePath = StressWorkerBench.this.mFilePaths[this.mTargetFileIndex];
            long startReadNs = System.nanoTime();
            if (this.mInStream == null) {
                this.mInStream = this.mFs.open(filePath);
            }
            int bytesRead = 0;
            if (this.mIsRandomRead) {
                long offset = StressWorkerBench.this.randomNumInRange(0L, this.mFileSize - 1L - this.mRandomMin);
                long lengthMax = Math.min(this.mFileSize - offset, this.mRandomMax);
                long length = StressWorkerBench.this.randomNumInRange(this.mRandomMin, lengthMax);
                while (length > 0L) {
                    int actualReadLength = this.mInStream.read(offset, this.mBuffer, 0, (int)StressWorkerBench.this.minLong(this.mBuffer.length, length));
                    if (actualReadLength < 0) {
                        this.closeInStream();
                        break;
                    }
                    bytesRead += actualReadLength;
                    length -= (long)actualReadLength;
                    offset += (long)actualReadLength;
                }
                this.closeInStream();
            } else {
                while (true) {
                    int actualReadLength;
                    if ((actualReadLength = this.mInStream.read(this.mBuffer)) < 0) {
                        this.closeInStream();
                        this.mInStream = this.mFs.open(filePath);
                        break;
                    }
                    bytesRead += actualReadLength;
                }
            }
            long afterReadNs = System.nanoTime();
            return new ApplyOperationOutput(bytesRead, afterReadNs - startReadNs);
        }

        private void closeInStream() {
            try {
                if (this.mInStream != null) {
                    this.mInStream.close();
                }
            }
            catch (IOException e) {
                this.mResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.mInStream = null;
            }
        }

        private class ApplyOperationOutput {
            public final long mBytesRead;
            public final long mDuration;

            public ApplyOperationOutput(long bytesRead, long duration) {
                this.mBytesRead = bytesRead;
                this.mDuration = duration;
            }
        }
    }

    private static final class BenchContext {
        private final long mStartMs;
        private final long mEndMs;
        private WorkerBenchTaskResult mResult;

        public BenchContext(long startMs, long endMs) {
            this.mStartMs = startMs;
            this.mEndMs = endMs;
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public synchronized void mergeThreadResult(WorkerBenchTaskResult threadResult) {
            if (this.mResult == null) {
                this.mResult = new WorkerBenchTaskResult();
            }
            try {
                this.mResult.merge(threadResult);
            }
            catch (Exception e) {
                this.mResult.addErrorMessage(e.getMessage());
            }
        }

        synchronized WorkerBenchTaskResult getResult() {
            return this.mResult;
        }
    }
}

