/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform.action;

import alluxio.table.common.transform.action.TransformAction;
import alluxio.table.common.transform.action.TransformActionFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformActionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TransformActionRegistry.class);
    private static final Map<String, TransformActionFactory> FACTORIES = new HashMap<String, TransformActionFactory>();

    private TransformActionRegistry() {
    }

    public static TransformAction create(String definition, String name, List<String> args, Map<String, String> options) {
        TransformActionFactory factory = FACTORIES.get(name);
        if (factory == null) {
            throw new IllegalStateException(String.format("TransformActionFactory for name '%s' does not exist.", name));
        }
        return factory.create(definition, args, options);
    }

    private static void refresh() {
        FACTORIES.clear();
        for (TransformActionFactory factory : ServiceLoader.load(TransformActionFactory.class, TransformActionFactory.class.getClassLoader())) {
            TransformActionFactory existingFactory = FACTORIES.get(factory.getName());
            if (existingFactory != null) {
                LOG.warn("Ignoring duplicate transform action '{}' found in factory {}. Existing factory: {}", new Object[]{factory.getName(), factory.getClass(), existingFactory.getClass()});
            }
            FACTORIES.put(factory.getName(), factory);
        }
        LOG.info("Registered Transform actions: " + String.join((CharSequence)",", FACTORIES.keySet()));
    }

    static {
        TransformActionRegistry.refresh();
    }
}

