/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform;

import alluxio.table.common.transform.action.TransformAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TransformDefinition {
    private final String mDefinition;
    private final List<TransformAction> mActions;

    private TransformDefinition(String definition, List<TransformAction> actions) {
        this.mDefinition = this.normalize(definition);
        this.mActions = actions;
    }

    private String normalize(String definition) {
        if ((definition = definition.trim()).endsWith(";")) {
            definition = definition.substring(0, definition.length() - 1);
        }
        return definition.toLowerCase();
    }

    public String getDefinition() {
        return this.mDefinition;
    }

    public List<TransformAction> getActions() {
        return this.mActions;
    }

    public static TransformDefinition parse(String definition) {
        if ((definition = definition.trim()).isEmpty()) {
            return new TransformDefinition(definition, Collections.emptyList());
        }
        String[] parts = definition.split(";");
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>(parts.length);
        for (String actionPart : parts) {
            actions.add(TransformAction.Parser.parse(actionPart));
        }
        return new TransformDefinition(definition, actions);
    }
}

