/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform;

import alluxio.job.JobConfig;
import alluxio.table.common.Layout;
import alluxio.table.common.transform.TransformDefinition;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class TransformPlan {
    private final Layout mBaseLayout;
    private final Layout mTransformedLayout;
    private final ArrayList<JobConfig> mJobConfigs;

    public TransformPlan(Layout baseLayout, Layout transformedLayout, TransformDefinition definition) {
        this.mBaseLayout = baseLayout;
        this.mTransformedLayout = transformedLayout;
        this.mJobConfigs = this.computeJobConfigs(definition);
    }

    private ArrayList<JobConfig> computeJobConfigs(TransformDefinition definition) {
        return definition.getActions().stream().map(action -> action.generateJobConfig(this.mBaseLayout, this.mTransformedLayout)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Layout getBaseLayout() {
        return this.mBaseLayout;
    }

    public Layout getTransformedLayout() {
        return this.mTransformedLayout;
    }

    public ArrayList<JobConfig> getJobConfigs() {
        return this.mJobConfigs;
    }
}

