/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform.action;

import alluxio.exception.ExceptionMessage;
import alluxio.job.JobConfig;
import alluxio.table.common.Layout;
import alluxio.table.common.transform.action.TransformActionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface TransformAction {
    public JobConfig generateJobConfig(Layout var1, Layout var2);

    public static class Parser {
        private static final Pattern COMPONENT_REGEX = Pattern.compile("^(?<name>[a-zA-Z]+\\w*)\\((?<args>[a-zA-Z_0-9., \\n\\t]*?)\\)");
        private static final Pattern ARG_REGEX = Pattern.compile("^[a-zA-Z_0-9.]+$");

        public static TransformAction parse(String definition) {
            definition = definition.trim();
            String actionName = null;
            List<String> argList = Collections.emptyList();
            HashMap<String, String> options = new HashMap<String, String>();
            while (!definition.isEmpty()) {
                Matcher matcher = COMPONENT_REGEX.matcher(definition);
                if (!matcher.find()) {
                    throw new IllegalArgumentException(ExceptionMessage.TRANSFORM_ACTION_PARSE_FAILED.getMessage(new Object[]{definition}));
                }
                String name = matcher.group("name");
                String args = matcher.group("args");
                if (!(definition = definition.substring(matcher.end()).trim()).isEmpty()) {
                    if (!definition.startsWith(".")) {
                        throw new IllegalArgumentException("Missing '.' at: " + definition);
                    }
                    definition = definition.substring(1);
                }
                if (actionName == null) {
                    actionName = name;
                    argList = Parser.parseArgList(args);
                    continue;
                }
                if (!name.equals("option")) {
                    throw new IllegalArgumentException("Expected an 'option()' component at: " + definition);
                }
                List<String> optionArgs = Parser.parseArgList(args);
                if (optionArgs.size() != 2) {
                    throw new IllegalArgumentException(String.format("Incorrect # args for option() component. args: %s", args));
                }
                options.put(optionArgs.get(0), optionArgs.get(1));
            }
            return TransformActionRegistry.create(definition, actionName, argList, options);
        }

        private static List<String> parseArgList(String args) {
            if ((args = args.trim()).isEmpty()) {
                return Collections.emptyList();
            }
            String[] argParts = args.split(",");
            ArrayList<String> argList = new ArrayList<String>(argParts.length);
            for (String argPart : argParts) {
                if (!ARG_REGEX.matcher(argPart = argPart.trim()).matches()) {
                    throw new IllegalArgumentException(String.format("Failed to parse argument '%s' from '%s'", argPart, args));
                }
                argList.add(argPart);
            }
            return argList;
        }
    }
}

