/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform.action;

import alluxio.exception.ExceptionMessage;
import alluxio.job.JobConfig;
import alluxio.job.plan.transform.CompactConfig;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.table.common.Layout;
import alluxio.table.common.transform.action.TransformAction;
import alluxio.table.common.transform.action.TransformActionFactory;
import alluxio.table.common.transform.action.TransformActionUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;

public class WriteAction
implements TransformAction {
    private static final String NAME = "write";
    private static final String NUM_FILES_OPTION = "hive.file.count.max";
    private static final String FILE_SIZE_OPTION = "hive.file.size.min";
    private static final long DEFAULT_FILE_SIZE = 0x80000000L;
    private static final int DEFAULT_NUM_FILES = 100;
    private final String mLayoutType;
    private final int mNumFiles;
    private final long mFileSize;

    private WriteAction(String type, int numFiles, long fileSize) {
        this.mLayoutType = type;
        this.mNumFiles = numFiles;
        this.mFileSize = fileSize;
    }

    @Override
    public JobConfig generateJobConfig(Layout base, Layout transformed) {
        PartitionInfo basePartitionInfo = TransformActionUtils.generatePartitionInfo(base);
        return new CompactConfig(basePartitionInfo, base.getLocation().toString(), transformed.getLocation().toString(), this.mLayoutType, Integer.valueOf(this.mNumFiles), Long.valueOf(this.mFileSize));
    }

    public static class WriteActionFactory
    implements TransformActionFactory {
        @Override
        public String getName() {
            return WriteAction.NAME;
        }

        @Override
        public TransformAction create(String definition, List<String> args, Map<String, String> options) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)ExceptionMessage.TRANSFORM_WRITE_ACTION_INVALID_ARGS.toString());
            String type = args.get(0);
            int numFiles = options.containsKey(WriteAction.NUM_FILES_OPTION) ? Integer.parseInt(options.get(WriteAction.NUM_FILES_OPTION)) : 100;
            long fileSize = options.containsKey(WriteAction.FILE_SIZE_OPTION) ? Long.parseLong(options.get(WriteAction.FILE_SIZE_OPTION)) : 0x80000000L;
            Preconditions.checkArgument((numFiles >= 0 ? 1 : 0) != 0, (Object)ExceptionMessage.TRANSFORM_WRITE_ACTION_INVALID_NUM_FILES);
            return new WriteAction(type, numFiles, fileSize);
        }
    }
}

