/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common;

import alluxio.exception.ExceptionMessage;
import alluxio.table.common.BaseProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfiguration<T extends BaseProperty> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConfiguration.class);
    protected final ConcurrentHashMap<String, String> mValues = new ConcurrentHashMap();

    protected BaseConfiguration() {
    }

    public BaseConfiguration(Map<String, String> values) {
        this.mValues.putAll(values);
    }

    public String get(T property) {
        String value = this.mValues.get(((BaseProperty)property).getName());
        if (value == null) {
            return ((BaseProperty)property).getDefaultValue();
        }
        return value;
    }

    public int getInt(T property) {
        String rawValue = this.get(property);
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(ExceptionMessage.KEY_NOT_INTEGER.getMessage(new Object[]{rawValue, property}));
        }
    }

    public Map<String, String> getMap() {
        return this.mValues;
    }
}

