/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.AlluxioURI;
import alluxio.exception.AlluxioException;
import alluxio.exception.InvalidPathException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.table.common.udb.UdbConfiguration;
import alluxio.table.common.udb.UdbContext;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdbUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UdbUtils.class);

    private UdbUtils() {
    }

    public static String mountAlluxioPath(String tableName, AlluxioURI ufsUri, AlluxioURI tableUri, UdbContext udbContext, UdbConfiguration udbConfiguration) throws IOException, AlluxioException {
        if (Objects.equals(ufsUri.getScheme(), "alluxio")) {
            return ufsUri.toString();
        }
        try {
            tableUri = udbContext.getFileSystem().reverseResolve(ufsUri);
            LOG.debug("Trying to mount table {} location {}, but it is already mounted at location {}", new Object[]{tableName, ufsUri, tableUri});
            return tableUri.getPath();
        }
        catch (InvalidPathException invalidPathException) {
            udbContext.getFileSystem().createDirectory(tableUri.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).setAllowExists(true).build());
            Map<String, String> mountOptionMap = udbConfiguration.getMountOption(String.format("%s://%s/", ufsUri.getScheme(), ufsUri.getAuthority().toString()));
            MountPOptions.Builder option = MountPOptions.newBuilder();
            for (Map.Entry<String, String> entry : mountOptionMap.entrySet()) {
                if (entry.getKey().equals("readonly")) {
                    option.setReadOnly(Boolean.parseBoolean(entry.getValue()));
                    continue;
                }
                if (entry.getKey().equals("shared")) {
                    option.setShared(Boolean.parseBoolean(entry.getValue()));
                    continue;
                }
                option.putProperties(entry.getKey(), entry.getValue());
            }
            udbContext.getFileSystem().mount(tableUri, ufsUri, option.build());
            LOG.info("mounted table {} location {} to Alluxio location {} with mountOption {}", new Object[]{tableName, ufsUri, tableUri, option.build()});
            return tableUri.getPath();
        }
    }
}

