/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.util.ConfigurationUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(PathTranslator.class);
    private BiMap<String, String> mPathMap = HashBiMap.create();

    public PathTranslator addMapping(String alluxioPath, String ufsPath) {
        while (alluxioPath.endsWith("/")) {
            alluxioPath = alluxioPath.substring(0, alluxioPath.length() - 1);
        }
        while (ufsPath.endsWith("/")) {
            ufsPath = ufsPath.substring(0, ufsPath.length() - 1);
        }
        this.mPathMap.put((Object)alluxioPath, (Object)ufsPath);
        return this;
    }

    public String toAlluxioPath(String ufsPath) throws IOException {
        for (Map.Entry entry : this.mPathMap.entrySet()) {
            if (!ufsPath.startsWith((String)entry.getValue())) continue;
            String alluxioPath = (String)entry.getKey() + ufsPath.substring(((String)entry.getValue()).length());
            if (alluxioPath.startsWith("/")) {
                alluxioPath = ConfigurationUtils.getSchemeAuthority((AlluxioConfiguration)ServerConfiguration.global()) + alluxioPath;
            }
            return alluxioPath;
        }
        throw new IOException(String.format("Failed to translate ufs path (%s). Mapping missing from translator", ufsPath));
    }
}

