/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.table.common.BaseConfiguration;
import alluxio.table.common.udb.UdbProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdbConfiguration
extends BaseConfiguration<UdbProperty> {
    private static final Logger LOG = LoggerFactory.getLogger(UdbConfiguration.class);
    private static final Pattern CONFIG_PATTERN = Pattern.compile("(\\{.*\\})\\.(.+?)");
    public static final String READ_ONLY_OPTION = "readonly";
    public static final String SHARED_OPTION = "shared";
    protected final Map<String, Map<String, String>> mMountOptions;

    public UdbConfiguration(Map<String, String> values) {
        super(values);
        this.mMountOptions = new HashMap<String, Map<String, String>>(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Map<String, String> optionMap;
            String key;
            Matcher m;
            if (!entry.getKey().startsWith("mount.option.") || !(m = CONFIG_PATTERN.matcher(key = entry.getKey().substring("mount.option.".length()))).matches()) continue;
            String schemeAuthority = m.group(1);
            String option = m.group(2);
            if (!(schemeAuthority = schemeAuthority.substring(1, schemeAuthority.length() - 1)).endsWith("/")) {
                schemeAuthority = schemeAuthority + "/";
            }
            if ((optionMap = this.mMountOptions.get(schemeAuthority)) == null) {
                optionMap = new HashMap<String, String>();
                optionMap.put(option, entry.getValue());
                this.mMountOptions.put(schemeAuthority, optionMap);
                continue;
            }
            optionMap.put(option, entry.getValue());
        }
    }

    public Map<String, String> getMountOption(String schemeAuthority) {
        if (!schemeAuthority.endsWith("/")) {
            schemeAuthority = schemeAuthority + "/";
        }
        return this.mMountOptions.getOrDefault(schemeAuthority, Collections.emptyMap());
    }
}

