/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform;

import alluxio.table.common.transform.action.TransformAction;
import alluxio.table.common.transform.action.TransformActionRegistry;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class TransformDefinition {
    private final String mDefinition;
    private final List<TransformAction> mActions;
    private final Properties mProperties;

    private TransformDefinition(String definition, List<TransformAction> actions, Properties properties) {
        this.mDefinition = this.normalize(definition);
        this.mActions = actions;
        this.mProperties = properties;
    }

    private String normalize(String definition) {
        if ((definition = definition.trim()).endsWith(";")) {
            definition = definition.substring(0, definition.length() - 1);
        }
        return definition.toLowerCase();
    }

    public String getDefinition() {
        return this.mDefinition;
    }

    public List<TransformAction> getActions() {
        return this.mActions;
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public static TransformDefinition parse(String definition) {
        if ((definition = definition.trim()).isEmpty()) {
            return new TransformDefinition(definition, Collections.emptyList(), new Properties());
        }
        definition = definition.replace(";", "\n");
        Properties properties = new Properties();
        StringReader reader = new StringReader(definition);
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            return new TransformDefinition(definition, Collections.emptyList(), properties);
        }
        List<TransformAction> actions = TransformActionRegistry.create(properties);
        return new TransformDefinition(definition, actions, properties);
    }
}

