/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform.action;

import alluxio.exception.ExceptionMessage;
import alluxio.job.JobConfig;
import alluxio.job.plan.transform.CompactConfig;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.table.common.Layout;
import alluxio.table.common.transform.action.TransformAction;
import alluxio.table.common.transform.action.TransformActionFactory;
import alluxio.table.common.transform.action.TransformActionUtils;
import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CompactAction
implements TransformAction {
    private static final String NUM_FILES_OPTION = "file.count.max";
    private static final String FILE_SIZE_OPTION = "file.size.min";
    private static final long DEFAULT_FILE_SIZE = 0x80000000L;
    private static final int DEFAULT_NUM_FILES = 100;
    private final int mNumFiles;
    private final long mFileSize;

    private CompactAction(int numFiles, long fileSize) {
        this.mNumFiles = numFiles;
        this.mFileSize = fileSize;
    }

    @Override
    public JobConfig generateJobConfig(Layout base, Layout transformed, boolean deleteSrc) {
        PartitionInfo basePartitionInfo = TransformActionUtils.generatePartitionInfo(base);
        PartitionInfo transformedPartitionInfo = TransformActionUtils.generatePartitionInfo(transformed);
        return new CompactConfig(basePartitionInfo, base.getLocation().toString(), transformedPartitionInfo, transformed.getLocation().toString(), Integer.valueOf(this.mNumFiles), Long.valueOf(this.mFileSize));
    }

    public static class CompactActionFactory
    implements TransformActionFactory {
        @Override
        public int getOrder() {
            return 0;
        }

        @Override
        public TransformAction create(Properties properties) {
            String numFilesString = properties.getProperty(CompactAction.NUM_FILES_OPTION);
            String fileSizeString = properties.getProperty(CompactAction.FILE_SIZE_OPTION);
            if (StringUtils.isEmpty((CharSequence)numFilesString) && StringUtils.isEmpty((CharSequence)fileSizeString)) {
                return null;
            }
            int numFiles = 100;
            if (!StringUtils.isEmpty((CharSequence)numFilesString)) {
                numFiles = Integer.parseInt(numFilesString);
            }
            long fileSize = 0x80000000L;
            if (!StringUtils.isEmpty((CharSequence)fileSizeString)) {
                fileSize = Long.parseLong(fileSizeString);
            }
            Preconditions.checkArgument((numFiles > 0 ? 1 : 0) != 0, (Object)ExceptionMessage.TRANSFORM_WRITE_ACTION_INVALID_NUM_FILES.getMessage(new Object[0]));
            return new CompactAction(numFiles, fileSize);
        }

        public String toString() {
            return "CompactActionFactory";
        }
    }
}

