/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.extensions.ExtensionsClassLoader;
import alluxio.table.common.udb.UdbConfiguration;
import alluxio.table.common.udb.UdbContext;
import alluxio.table.common.udb.UnderDatabase;
import alluxio.table.common.udb.UnderDatabaseFactory;
import alluxio.util.io.PathUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnderDatabaseRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UnderDatabaseRegistry.class);
    private static final String UDB_EXTENSION_PATTERN = "alluxio-table-server-underdb-*.jar";
    private volatile Map<String, UnderDatabaseFactory> mFactories = new HashMap<String, UnderDatabaseFactory>();

    public void refresh() {
        HashMap<String, UnderDatabaseFactory> map = new HashMap<String, UnderDatabaseFactory>();
        String libDir = PathUtils.concatPath((Object)ServerConfiguration.global().get(PropertyKey.HOME), (Object)"lib");
        LOG.info("Loading udb jars from {}", (Object)libDir);
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(libDir, new String[0]), UDB_EXTENSION_PATTERN);){
            for (Path entry : stream) {
                if (!entry.toFile().isFile()) continue;
                files.add(entry.toFile());
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to load udb libs from {}. error: {}", (Object)libDir, (Object)e.toString());
        }
        for (File jar : files) {
            try {
                URL extensionURL = jar.toURI().toURL();
                ExtensionsClassLoader extensionsClassLoader = new ExtensionsClassLoader(new URL[]{extensionURL}, ClassLoader.getSystemClassLoader());
                for (UnderDatabaseFactory factory : ServiceLoader.load(UnderDatabaseFactory.class, (ClassLoader)extensionsClassLoader)) {
                    UnderDatabaseFactory existingFactory = (UnderDatabaseFactory)map.get(factory.getType());
                    if (existingFactory != null) {
                        LOG.warn("Ignoring duplicate under database type '{}' found in {}. Existing factory: {}", new Object[]{factory.getType(), factory.getClass(), existingFactory.getClass()});
                    }
                    map.put(factory.getType(), factory);
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to load udb jar {}", (Object)jar, (Object)t);
            }
        }
        for (UnderDatabaseFactory factory : ServiceLoader.load(UnderDatabaseFactory.class, UnderDatabaseRegistry.class.getClassLoader())) {
            UnderDatabaseFactory existingFactory = (UnderDatabaseFactory)map.get(factory.getType());
            if (existingFactory != null) {
                LOG.warn("Ignoring duplicate under database type '{}' found in {}. Existing factory: {}", new Object[]{factory.getType(), factory.getClass(), existingFactory.getClass()});
            }
            map.put(factory.getType(), factory);
        }
        this.mFactories = map;
        LOG.info("Registered UDBs: " + String.join((CharSequence)",", this.mFactories.keySet()));
    }

    public UnderDatabase create(UdbContext udbContext, String type, UdbConfiguration configuration) {
        Map<String, UnderDatabaseFactory> map = this.mFactories;
        UnderDatabaseFactory factory = map.get(type);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("UdbFactory for type '%s' does not exist.", type));
        }
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
            UnderDatabase underDatabase = factory.create(udbContext, configuration);
            return underDatabase;
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("Failed to create UnderDb by factory %s", factory), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

