/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.layout;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.grpc.table.layout.hive.StorageFormat;
import alluxio.table.common.Layout;
import alluxio.table.common.LayoutFactory;
import alluxio.table.common.transform.TransformContext;
import alluxio.table.common.transform.TransformDefinition;
import alluxio.table.common.transform.TransformPlan;
import alluxio.util.ConfigurationUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveLayout
implements Layout {
    private static final Logger LOG = LoggerFactory.getLogger(HiveLayout.class);
    public static final String TYPE = "hive";
    private final PartitionInfo mPartitionInfo;
    private final Map<String, ColumnStatisticsInfo> mPartitionStatsInfo;

    public HiveLayout(PartitionInfo partitionInfo, List<ColumnStatisticsInfo> stats) {
        this.mPartitionInfo = partitionInfo;
        this.mPartitionStatsInfo = stats.stream().collect(Collectors.toMap(ColumnStatisticsInfo::getColName, e -> e, (e1, e2) -> e2));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getSpec() {
        return this.mPartitionInfo.getPartitionName();
    }

    public PartitionInfo getData() {
        return this.mPartitionInfo;
    }

    @Override
    public AlluxioURI getLocation() {
        return new AlluxioURI(this.mPartitionInfo.getStorage().getLocation());
    }

    @Override
    public Map<String, ColumnStatisticsInfo> getColumnStatsData() {
        return this.mPartitionStatsInfo;
    }

    private HiveLayout transformLayout(AlluxioURI transformedUri, TransformDefinition definition) {
        Properties properties = definition.getProperties();
        StorageFormat.Builder storageFormatBuilder = this.mPartitionInfo.getStorage().getStorageFormat().toBuilder().setSerde("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").setInputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat").setOutputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
        String compressionKey = "file.parquet.compression";
        String compression = properties.getProperty("file.parquet.compression");
        if (!StringUtils.isEmpty((CharSequence)compression)) {
            storageFormatBuilder.putSerdelibParameters("file.parquet.compression", compression);
        }
        PartitionInfo info = this.mPartitionInfo.toBuilder().putAllParameters(this.mPartitionInfo.getParametersMap()).setStorage(this.mPartitionInfo.getStorage().toBuilder().setStorageFormat(storageFormatBuilder.build()).setLocation(transformedUri.toString()).build()).build();
        ArrayList<ColumnStatisticsInfo> stats = new ArrayList<ColumnStatisticsInfo>(this.mPartitionStatsInfo.values());
        return new HiveLayout(info, stats);
    }

    @Override
    public TransformPlan getTransformPlan(TransformContext transformContext, TransformDefinition definition) throws IOException {
        AlluxioURI outputPath = transformContext.generateTransformedPath();
        AlluxioURI outputUri = new AlluxioURI(ConfigurationUtils.getSchemeAuthority((AlluxioConfiguration)ServerConfiguration.global()) + outputPath.getPath());
        HiveLayout transformedLayout = this.transformLayout(outputUri, definition);
        return new TransformPlan(this, transformedLayout, definition);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HiveLayout)) {
            return false;
        }
        HiveLayout that = (HiveLayout)obj;
        return Objects.equals(this.mPartitionInfo, that.mPartitionInfo) && Objects.equals(this.mPartitionStatsInfo, that.mPartitionStatsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.mPartitionInfo, this.mPartitionStatsInfo);
    }

    public static class HiveLayoutFactory
    implements LayoutFactory {
        @Override
        public String getType() {
            return HiveLayout.TYPE;
        }

        @Override
        public Layout create(alluxio.grpc.table.Layout layoutProto) {
            if (!HiveLayout.TYPE.equals(layoutProto.getLayoutType())) {
                throw new IllegalStateException("Cannot parse HiveLayout from layout type: " + layoutProto.getLayoutType());
            }
            if (!layoutProto.hasLayoutData()) {
                throw new IllegalStateException("Cannot parse layout from empty layout data");
            }
            try {
                PartitionInfo partitionInfo = PartitionInfo.parseFrom((ByteString)layoutProto.getLayoutData());
                return new HiveLayout(partitionInfo, new ArrayList<ColumnStatisticsInfo>(layoutProto.getStatsMap().values()));
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("Cannot parse HiveLayout from proto layout", e);
            }
        }
    }
}

