/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform.action;

import alluxio.table.common.transform.action.TransformAction;
import alluxio.table.common.transform.action.TransformActionFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformActionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TransformActionRegistry.class);
    private static final List<TransformActionFactory> FACTORIES = new ArrayList<TransformActionFactory>();

    private TransformActionRegistry() {
    }

    public static List<TransformAction> create(Properties definition) {
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>();
        for (TransformActionFactory factory : FACTORIES) {
            TransformAction transformAction = factory.create(definition);
            if (transformAction == null) continue;
            actions.add(transformAction);
        }
        return actions;
    }

    @VisibleForTesting
    public static List<TransformActionFactory> getFactories() {
        return Collections.unmodifiableList(FACTORIES);
    }

    private static void refresh() {
        FACTORIES.clear();
        for (TransformActionFactory factory2 : ServiceLoader.load(TransformActionFactory.class, TransformActionFactory.class.getClassLoader())) {
            FACTORIES.add(factory2);
        }
        FACTORIES.sort(Comparator.comparingInt(factory -> factory.getOrder()));
        LOG.info("Registered Transform actions: " + StringUtils.join(FACTORIES, (String)","));
    }

    static {
        TransformActionRegistry.refresh();
    }
}

