/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform;

import alluxio.AlluxioURI;
import alluxio.table.common.CatalogPathUtils;
import alluxio.util.CommonUtils;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class TransformContext {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyyMMdd-HHmmss-SSS", (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault());
    private final String mDbName;
    private final String mTableName;
    private final String mIdentifier;

    public TransformContext(String dbName, String tableName, String identifier) {
        this.mDbName = dbName;
        this.mTableName = tableName;
        this.mIdentifier = identifier;
    }

    public AlluxioURI generateTransformedPath() {
        String random = String.format("%s-%s", DATE_FORMAT.format(new Date()), CommonUtils.randomAlphaNumString((int)5));
        return CatalogPathUtils.getTablePathInternal(this.mDbName, this.mTableName).join(this.mIdentifier).join(random);
    }
}

