/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.transform;

import alluxio.job.JobConfig;
import alluxio.table.common.Layout;
import alluxio.table.common.transform.TransformDefinition;
import alluxio.table.common.transform.action.TransformAction;
import java.util.ArrayList;

public class TransformPlan {
    private final Layout mBaseLayout;
    private final Layout mTransformedLayout;
    private final ArrayList<JobConfig> mJobConfigs;

    public TransformPlan(Layout baseLayout, Layout transformedLayout, TransformDefinition definition) {
        this.mBaseLayout = baseLayout;
        this.mTransformedLayout = transformedLayout;
        this.mJobConfigs = this.computeJobConfigs(definition);
    }

    private ArrayList<JobConfig> computeJobConfigs(TransformDefinition definition) {
        ArrayList<JobConfig> actions = new ArrayList<JobConfig>();
        Layout baseLayout = this.mBaseLayout;
        boolean deleteSrc = false;
        for (TransformAction action : definition.getActions()) {
            actions.add(action.generateJobConfig(baseLayout, this.mTransformedLayout, deleteSrc));
            baseLayout = this.mTransformedLayout;
            deleteSrc = true;
        }
        if (actions.isEmpty()) {
            throw new IllegalArgumentException("At least one action should be defined for the transformation");
        }
        return actions;
    }

    public Layout getBaseLayout() {
        return this.mBaseLayout;
    }

    public Layout getTransformedLayout() {
        return this.mTransformedLayout;
    }

    public ArrayList<JobConfig> getJobConfigs() {
        return this.mJobConfigs;
    }
}

