/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import java.util.Map;
import java.util.Set;

public final class UdbBypassSpec {
    private final Map<String, Set<String>> mTablePartMap;

    public UdbBypassSpec(Map<String, Set<String>> tablePartMap) {
        this.mTablePartMap = tablePartMap;
    }

    public boolean hasTable(String tableName) {
        return this.mTablePartMap.containsKey(tableName);
    }

    public boolean hasFullTable(String tableName) {
        return this.hasTable(tableName) && this.mTablePartMap.get(tableName).size() == 0;
    }

    public boolean hasPartition(String tableName, String partitionName) {
        if (!this.hasTable(tableName)) {
            return false;
        }
        Set<String> parts = this.mTablePartMap.get(tableName);
        if (parts.size() == 0) {
            return true;
        }
        return parts.contains(partitionName);
    }
}

