/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common;

import alluxio.table.common.Layout;
import alluxio.table.common.LayoutFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutRegistry.class);
    private volatile Map<String, LayoutFactory> mFactories = new HashMap<String, LayoutFactory>();

    public void refresh() {
        HashMap<String, LayoutFactory> map = new HashMap<String, LayoutFactory>();
        for (LayoutFactory factory : ServiceLoader.load(LayoutFactory.class, LayoutRegistry.class.getClassLoader())) {
            LayoutFactory existingFactory = (LayoutFactory)map.get(factory.getType());
            if (existingFactory != null) {
                LOG.warn("Ignoring duplicate layout type '{}' found in factory {}. Existing factory: {}", new Object[]{factory.getType(), factory.getClass(), existingFactory.getClass()});
            }
            map.put(factory.getType(), factory);
        }
        this.mFactories = map;
        LOG.info("Registered Table Layouts: " + String.join((CharSequence)",", this.mFactories.keySet()));
    }

    public Layout create(alluxio.grpc.table.Layout layoutProto) {
        Map<String, LayoutFactory> map = this.mFactories;
        String type = layoutProto.getLayoutType();
        LayoutFactory factory = map.get(type);
        if (factory == null) {
            throw new IllegalStateException(String.format("LayoutFactory for type '%s' does not exist.", type));
        }
        return factory.create(layoutProto);
    }
}

