/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.InvalidPathException;
import alluxio.util.ConfigurationUtils;
import alluxio.util.io.PathUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(PathTranslator.class);
    private static final String SCHEME_AUTHORITY_PREFIX = ConfigurationUtils.getSchemeAuthority((AlluxioConfiguration)Configuration.global());
    private static final AlluxioURI BASE_URI = new AlluxioURI(SCHEME_AUTHORITY_PREFIX);
    private final BiMap<AlluxioURI, AlluxioURI> mPathMap = HashBiMap.create();

    public PathTranslator addMapping(String alluxioPath, String ufsPath) {
        this.mPathMap.put((Object)new AlluxioURI(alluxioPath), (Object)new AlluxioURI(ufsPath));
        return this;
    }

    public String toAlluxioPath(String ufsPath) throws IOException {
        String suffix = ufsPath.endsWith("/") ? "/" : "";
        AlluxioURI ufsUri = new AlluxioURI(ufsPath);
        if (this.mPathMap.inverse().containsKey((Object)ufsUri)) {
            AlluxioURI match = (AlluxioURI)this.mPathMap.inverse().get((Object)ufsUri);
            if (match.equals((Object)ufsUri)) {
                return ufsPath;
            }
            return PathTranslator.checkAndAddSchemeAuthority((AlluxioURI)this.mPathMap.inverse().get((Object)ufsUri)) + suffix;
        }
        Map.Entry longestPrefix = null;
        int longestPrefixDepth = -1;
        for (Map.Entry entry : this.mPathMap.entrySet()) {
            try {
                AlluxioURI valueUri = (AlluxioURI)entry.getValue();
                if (!valueUri.isAncestorOf(ufsUri) || valueUri.getDepth() <= longestPrefixDepth) continue;
                longestPrefix = entry;
                longestPrefixDepth = valueUri.getDepth();
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
        if (longestPrefix == null) {
            throw new IOException(String.format("Failed to translate ufs path (%s). Mapping missing from translator", ufsPath));
        }
        if (((AlluxioURI)longestPrefix.getKey()).equals(longestPrefix.getValue())) {
            return ufsPath;
        }
        try {
            String difference = PathUtils.subtractPaths((String)ufsUri.getPath(), (String)((AlluxioURI)longestPrefix.getValue()).getPath());
            AlluxioURI mappedUri = ((AlluxioURI)longestPrefix.getKey()).join(difference);
            return PathTranslator.checkAndAddSchemeAuthority(mappedUri) + suffix;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    private static AlluxioURI checkAndAddSchemeAuthority(AlluxioURI input) {
        if (!input.hasScheme()) {
            return new AlluxioURI(BASE_URI, input.getPath(), false);
        }
        return input;
    }
}

