/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.grpc.table.PrincipalType;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class DatabaseInfo {
    @Nullable
    private final String mLocation;
    @Nullable
    private final String mOwnerName;
    @Nullable
    private final PrincipalType mOwnerType;
    @Nullable
    private final String mComment;
    private final Map<String, String> mParameters;

    public DatabaseInfo(String location, String ownerName, PrincipalType ownerType, String comment, Map<String, String> params) {
        this.mLocation = location;
        this.mOwnerName = ownerName;
        this.mOwnerType = ownerType;
        this.mComment = comment;
        this.mParameters = params == null ? Collections.emptyMap() : params;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public String getOwnerName() {
        return this.mOwnerName;
    }

    public PrincipalType getOwnerType() {
        return this.mOwnerType;
    }

    public String getComment() {
        return this.mComment;
    }

    public Map<String, String> getParameters() {
        return this.mParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseInfo that = (DatabaseInfo)o;
        return Objects.equals(this.mLocation, that.mLocation) && Objects.equals(this.mOwnerName, that.mOwnerName) && this.mOwnerType == that.mOwnerType && Objects.equals(this.mComment, that.mComment) && Objects.equals(this.mParameters, that.mParameters);
    }

    public int hashCode() {
        return Objects.hash(this.mLocation, this.mOwnerName, this.mOwnerType, this.mComment, this.mParameters);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.mLocation).add("ownerName", (Object)this.mOwnerName).add("ownerType", (Object)this.mOwnerType).add("comment", (Object)this.mComment).add("parameters", this.mParameters).toString();
    }
}

