/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.table.common.CatalogPathUtils;
import alluxio.table.common.udb.UnderDatabaseRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdbContext {
    private static final Logger LOG = LoggerFactory.getLogger(UdbContext.class);
    private final UnderDatabaseRegistry mUdbRegistry;
    private final FileSystem mFileSystem;
    private final String mType;
    private final String mConnectionUri;
    private final String mUdbDbName;
    private final String mDbName;

    public UdbContext(UnderDatabaseRegistry udbRegistry, FileSystem fileSystem, String type, String connectionUri, String udbDbName, String dbName) {
        this.mUdbRegistry = udbRegistry;
        this.mFileSystem = fileSystem;
        this.mType = type;
        this.mConnectionUri = connectionUri;
        this.mUdbDbName = udbDbName;
        this.mDbName = dbName;
    }

    public String getDbName() {
        return this.mDbName;
    }

    public FileSystem getFileSystem() {
        return this.mFileSystem;
    }

    public UnderDatabaseRegistry getUdbRegistry() {
        return this.mUdbRegistry;
    }

    public String getConnectionUri() {
        return this.mConnectionUri;
    }

    public String getUdbDbName() {
        return this.mUdbDbName;
    }

    public AlluxioURI getTableLocation(String tableName) {
        return CatalogPathUtils.getTablePathUdb(this.mDbName, tableName, this.mType);
    }
}

