/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.common.udb;

import alluxio.table.common.BaseConfiguration;
import alluxio.table.common.udb.UdbProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdbConfiguration
extends BaseConfiguration<UdbProperty> {
    private static final Logger LOG = LoggerFactory.getLogger(UdbConfiguration.class);
    private static final Pattern CONFIG_PATTERN = Pattern.compile("(\\{.*\\})\\.(.+?)");
    public static final String READ_ONLY_OPTION = "readonly";
    public static final String SHARED_OPTION = "shared";
    public static final String REGEX_PREFIX = "regex:";
    protected final Map<String, Map<String, String>> mMountOptions;

    public UdbConfiguration(Map<String, String> values) {
        super(values);
        this.mMountOptions = new HashMap<String, Map<String, String>>(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Map<String, String> optionMap;
            String key;
            Matcher m;
            if (!entry.getKey().startsWith("mount.option.") || !(m = CONFIG_PATTERN.matcher(key = entry.getKey().substring("mount.option.".length()))).matches()) continue;
            Object templateSchemeAuthority = m.group(1);
            String option = m.group(2);
            if (!((String)(templateSchemeAuthority = ((String)templateSchemeAuthority).substring(1, ((String)templateSchemeAuthority).length() - 1))).endsWith("/")) {
                templateSchemeAuthority = (String)templateSchemeAuthority + "/";
            }
            if ((optionMap = this.mMountOptions.get(templateSchemeAuthority)) == null) {
                optionMap = new HashMap<String, String>();
                optionMap.put(option, entry.getValue());
                this.mMountOptions.put((String)templateSchemeAuthority, optionMap);
                continue;
            }
            optionMap.put(option, entry.getValue());
        }
    }

    public Map<String, String> getMountOption(String concreteSchemeAuthority) {
        Map<String, String> map;
        if (!((String)concreteSchemeAuthority).endsWith("/")) {
            concreteSchemeAuthority = (String)concreteSchemeAuthority + "/";
        }
        if ((map = this.mMountOptions.getOrDefault(concreteSchemeAuthority, Collections.emptyMap())).equals(Collections.emptyMap())) {
            for (Map.Entry<String, Map<String, String>> entry : this.mMountOptions.entrySet()) {
                if (!entry.getKey().startsWith(REGEX_PREFIX) || !((String)concreteSchemeAuthority).matches(entry.getKey().substring(REGEX_PREFIX.length()))) continue;
                return entry.getValue();
            }
        }
        return map;
    }
}

