/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.master.backcompat.FsTestOp;
import alluxio.security.authorization.Mode;
import alluxio.security.authorization.ModeParser;
import java.util.Arrays;
import org.junit.Assert;

public final class CreateDirectory
extends FsTestOp {
    private static final AlluxioURI DIR = new AlluxioURI("/createDirectory");
    private static final AlluxioURI NESTED_DIR = new AlluxioURI("/createDirectory/a");
    private static final AlluxioURI NESTED_NESTED_DIR = new AlluxioURI("/createDirectory/a/b");
    private static final AlluxioURI RECURSIVE = new AlluxioURI("/createDirectoryRecursive/a/b");
    private static final Mode TEST_MODE = ModeParser.parse((String)"u=rwx,g=x,o=wx");
    private static final AlluxioURI MODE_DIR = new AlluxioURI("/createDirectoryMode/a");
    private static final Long TTL = 0x3FFFFFFFFFFFFFFFL;
    private static final AlluxioURI TTL_DIR = new AlluxioURI("/createDirectoryTtl/a");
    private static final AlluxioURI COMMON_TTL_DIR = new AlluxioURI("/createDirectoryCommonTtl/a");
    private static final AlluxioURI THROUGH_DIR = new AlluxioURI("/createDirectoryThrough/a");
    private static final AlluxioURI ALL_OPTS_DIR = new AlluxioURI("/createDirectoryAllOpts/a");

    @Override
    public void apply(FileSystem fs) throws Exception {
        fs.createDirectory(DIR);
        fs.createDirectory(NESTED_DIR);
        fs.createDirectory(NESTED_NESTED_DIR);
        fs.createDirectory(RECURSIVE, CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        fs.createDirectory(RECURSIVE, CreateDirectoryPOptions.newBuilder().setAllowExists(true).build());
        fs.createDirectory(MODE_DIR, CreateDirectoryPOptions.newBuilder().setMode(TEST_MODE.toProto()).setRecursive(true).build());
        fs.createDirectory(COMMON_TTL_DIR, CreateDirectoryPOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(TTL.longValue()).setTtlAction(TtlAction.DELETE)).build());
        fs.createDirectory(TTL_DIR, CreateDirectoryPOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(TTL.longValue()).setTtlAction(TtlAction.DELETE)).setRecursive(true).build());
        fs.createDirectory(THROUGH_DIR, CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.THROUGH).setRecursive(true).build());
        fs.createDirectory(ALL_OPTS_DIR, CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(TEST_MODE.toProto()).setAllowExists(true).setWriteType(WritePType.THROUGH).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(TTL.longValue()).setTtlAction(TtlAction.DELETE)).build());
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        for (AlluxioURI dir : Arrays.asList(DIR, NESTED_DIR, NESTED_NESTED_DIR, RECURSIVE, MODE_DIR, TTL_DIR, COMMON_TTL_DIR, THROUGH_DIR, ALL_OPTS_DIR)) {
            Assert.assertTrue((boolean)fs.exists(dir));
        }
        Assert.assertEquals((Object)TEST_MODE, (Object)new Mode((short)fs.getStatus(MODE_DIR).getMode()));
        Assert.assertEquals((long)TTL, (long)fs.getStatus(TTL_DIR).getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)fs.getStatus(TTL_DIR).getTtlAction());
        Assert.assertEquals((long)TTL, (long)fs.getStatus(COMMON_TTL_DIR).getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)fs.getStatus(COMMON_TTL_DIR).getTtlAction());
        Assert.assertTrue((boolean)fs.getStatus(THROUGH_DIR).isPersisted());
        Assert.assertEquals((Object)TEST_MODE, (Object)new Mode((short)fs.getStatus(ALL_OPTS_DIR).getMode()));
        Assert.assertEquals((long)TTL, (long)fs.getStatus(ALL_OPTS_DIR).getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)fs.getStatus(ALL_OPTS_DIR).getTtlAction());
        Assert.assertTrue((boolean)fs.getStatus(ALL_OPTS_DIR).isPersisted());
    }
}

