/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.grpc.DeletePOptions;
import alluxio.master.backcompat.FsTestOp;
import alluxio.master.backcompat.Utils;
import java.util.Arrays;
import org.junit.Assert;

public final class Delete
extends FsTestOp {
    private static final AlluxioURI PATH = new AlluxioURI("/pathToDelete");
    private static final AlluxioURI NESTED = new AlluxioURI("/deleteFile/a");
    private static final AlluxioURI RECURSIVE = new AlluxioURI("/deleteRecursive/a/b");

    @Override
    public void apply(FileSystem fs) throws Exception {
        Utils.createFile(fs, PATH);
        fs.delete(PATH);
        Utils.createFile(fs, NESTED);
        fs.delete(NESTED);
        Utils.createFile(fs, RECURSIVE);
        fs.delete(RECURSIVE.getParent(), DeletePOptions.newBuilder().setRecursive(true).build());
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        for (AlluxioURI deleted : Arrays.asList(PATH, NESTED, RECURSIVE)) {
            Assert.assertFalse((boolean)fs.exists(deleted));
        }
        Assert.assertTrue((boolean)fs.exists(NESTED.getParent()));
        Assert.assertFalse((boolean)fs.exists(RECURSIVE.getParent()));
        Assert.assertTrue((boolean)fs.exists(RECURSIVE.getParent().getParent()));
    }
}

