/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.master.backcompat.FsTestOp;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import org.junit.Assert;

public final class Mount
extends FsTestOp {
    private static final AlluxioURI ALLUXIO_MOUNT_PATH = new AlluxioURI("/mount");
    private static final AlluxioURI ALLUXIO_UNMOUNT_PATH = new AlluxioURI("/unmount");
    private static final String LOCAL_FS_MOUNT_DIR = "/tmp/alluxioTest/mount";
    private static final String LOCAL_FS_UNMOUNT_DIR = "/tmp/alluxioTest/unmount";
    private static final AlluxioURI UFS_MOUNT_PATH = new AlluxioURI("/tmp/alluxioTest/mount");
    private static final AlluxioURI UFS_UNMOUNT_PATH = new AlluxioURI("/tmp/alluxioTest/unmount");

    @Override
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Findbugs doesn't like the use of an absolute path. However, we need one here so that generated journals are portable across machines")
    public void apply(FileSystem fs) throws Exception {
        new File(LOCAL_FS_MOUNT_DIR).mkdirs();
        fs.mount(ALLUXIO_MOUNT_PATH, UFS_MOUNT_PATH);
        new File(LOCAL_FS_UNMOUNT_DIR).mkdirs();
        fs.mount(ALLUXIO_UNMOUNT_PATH, UFS_UNMOUNT_PATH);
        fs.unmount(ALLUXIO_UNMOUNT_PATH);
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        Assert.assertTrue((boolean)fs.getStatus(ALLUXIO_MOUNT_PATH).isMountPoint());
        Assert.assertFalse((boolean)fs.exists(ALLUXIO_UNMOUNT_PATH));
    }
}

