/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.backcompat.FsTestOp;
import alluxio.util.CommonUtils;
import java.io.IOException;
import org.junit.Assert;

public final class AsyncPersist
extends FsTestOp {
    private static final AlluxioURI FILE = new AlluxioURI("/asyncPersist");
    private static final AlluxioURI NESTED_FILE = new AlluxioURI("/asyncPersistDir/nested");

    @Override
    public void apply(FileSystem fs) throws Exception {
        try (FileOutStream out = fs.createFile(FILE, CreateFilePOptions.newBuilder().setBlockSizeBytes(1024L).setWriteType(WritePType.ASYNC_THROUGH).build());){
            out.write("test".getBytes());
        }
        out = fs.createFile(NESTED_FILE, CreateFilePOptions.newBuilder().setBlockSizeBytes(1024L).setWriteType(WritePType.ASYNC_THROUGH).setRecursive(true).build());
        try {
            out.write("test".getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        CommonUtils.waitFor((String)"files to be persisted", () -> {
            try {
                return fs.getStatus(FILE).isPersisted() && fs.getStatus(NESTED_FILE).isPersisted();
            }
            catch (AlluxioException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        Assert.assertTrue((boolean)fs.getStatus(FILE).isPersisted());
        Assert.assertTrue((boolean)fs.getStatus(NESTED_FILE).isPersisted());
        Assert.assertTrue((boolean)fs.getStatus(NESTED_FILE.getParent()).isPersisted());
    }
}

