/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat;

import alluxio.master.backcompat.Version;
import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Journal {
    private static final String VERSION = "(?<major>\\d+).(?<minor>\\d+).(?<patch>\\d+).*";
    private static final Pattern JOURNAL_VERSION_RE = Pattern.compile("journal-(?<major>\\d+).(?<minor>\\d+).(?<patch>\\d+).*");
    private static final Pattern BACKUP_VERSION_RE = Pattern.compile("backup-(?<major>\\d+).(?<minor>\\d+).(?<patch>\\d+).*");
    private final boolean mIsBackup;
    private final String mDir;
    private final Version mVersion;

    private Journal(boolean isBackup, String dir, Version version) {
        this.mIsBackup = isBackup;
        this.mDir = dir;
        this.mVersion = version;
    }

    public boolean isBackup() {
        return this.mIsBackup;
    }

    public String getDir() {
        return this.mDir;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public static Optional<Journal> parse(String path) {
        File f = new File(path);
        boolean isBackup = false;
        Matcher matcher = JOURNAL_VERSION_RE.matcher(f.getName());
        if (!matcher.matches()) {
            isBackup = true;
            matcher = BACKUP_VERSION_RE.matcher(f.getName());
            if (!matcher.matches()) {
                return Optional.empty();
            }
        }
        int major = Integer.parseInt(matcher.group("major"));
        int minor = Integer.parseInt(matcher.group("minor"));
        int patch = Integer.parseInt(matcher.group("patch"));
        return Optional.of(new Journal(isBackup, path, new Version(major, minor, patch)));
    }
}

