/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.master.backcompat.TestOp;
import alluxio.master.backcompat.Utils;
import alluxio.multi.process.Clients;
import alluxio.util.CommonUtils;
import alluxio.util.FileSystemOptions;
import alluxio.util.WaitForOptions;
import java.util.Arrays;
import org.junit.Assert;

public final class PersistFile
implements TestOp {
    private static final AlluxioURI PATH = new AlluxioURI("/fileToPersist");
    private static final AlluxioURI NESTED_PATH = new AlluxioURI("/persistFileDir/a");

    @Override
    public void apply(Clients clients) throws Exception {
        FileSystem fs = clients.getFileSystemClient();
        Utils.createFile(fs, PATH);
        clients.getFileSystemMasterClient().scheduleAsyncPersist(PATH, FileSystemOptions.scheduleAsyncPersistDefaults((AlluxioConfiguration)ServerConfiguration.global()));
        Utils.createFile(fs, NESTED_PATH);
        clients.getFileSystemMasterClient().scheduleAsyncPersist(NESTED_PATH, FileSystemOptions.scheduleAsyncPersistDefaults((AlluxioConfiguration)ServerConfiguration.global()));
        CommonUtils.waitFor((String)"file to be async persisted", () -> {
            try {
                return fs.getStatus(PATH).isPersisted() && fs.getStatus(NESTED_PATH).isPersisted();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000));
    }

    @Override
    public void check(Clients clients) throws Exception {
        for (AlluxioURI uri : Arrays.asList(PATH, NESTED_PATH, NESTED_PATH.getParent())) {
            Assert.assertTrue((boolean)clients.getFileSystemClient().getStatus(uri).isPersisted());
        }
    }
}

