/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.grpc.BackupPOptions;
import alluxio.grpc.BackupPRequest;
import alluxio.master.backcompat.TestOp;
import alluxio.master.backcompat.ops.AsyncPersist;
import alluxio.master.backcompat.ops.CreateDirectory;
import alluxio.master.backcompat.ops.CreateFile;
import alluxio.master.backcompat.ops.Delete;
import alluxio.master.backcompat.ops.Mount;
import alluxio.master.backcompat.ops.PersistDirectory;
import alluxio.master.backcompat.ops.PersistFile;
import alluxio.master.backcompat.ops.Rename;
import alluxio.master.backcompat.ops.SetAcl;
import alluxio.master.backcompat.ops.UpdateUfsMode;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.security.user.ServerUserState;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;

public final class BackwardsCompatibilityJournalGenerator {
    public static final String OLD_JOURNALS_RESOURCE = "src/test/resources/old_journals";
    public static final List<TestOp> OPS = ImmutableList.builder().add((Object[])new TestOp[]{new CreateDirectory(), new CreateFile(), new Mount(), new AsyncPersist(), new Delete(), new PersistFile(), new PersistDirectory(), new Rename(), new SetAcl(), new UpdateUfsMode()}).build();
    @Parameter(required=true, names={"-o", "--outputDirectory"}, description="The directory to write generated journal artifacts to")
    private String mOutputDirectory;

    public String getOutputDirectory() {
        return this.mOutputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File backupDst;
        File journalDst;
        BackwardsCompatibilityJournalGenerator generator = new BackwardsCompatibilityJournalGenerator();
        new JCommander((Object)generator, args);
        if (!ServerUserState.global().getUser().getName().equals("root")) {
            System.err.printf("Journals must be generated as root so that they can be replayed by root%n", new Object[0]);
            System.exit(-1);
        }
        if ((journalDst = new File(generator.getOutputDirectory(), String.format("journal-%s", "2.9.3"))).exists()) {
            System.err.printf("%s already exists, delete it first%n", journalDst.getAbsolutePath());
            System.exit(-1);
        }
        if ((backupDst = new File(generator.getOutputDirectory(), String.format("backup-%s", "2.9.3"))).exists()) {
            System.err.printf("%s already exists, delete it first%n", backupDst.getAbsolutePath());
            System.exit(-1);
        }
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKWARDS_COMPATIBILITY).setClusterName("BackwardsCompatibility").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).build();
        try {
            cluster.start();
            cluster.notifySuccess();
            cluster.waitForAllNodesRegistered(10000);
            for (TestOp op : OPS) {
                op.apply(cluster.getClients());
            }
            AlluxioURI backup = cluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(new File(generator.getOutputDirectory()).getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(true)).build()).getBackupUri();
            FileUtils.moveFile((File)new File(backup.getPath()), (File)backupDst);
            cluster.stopMasters();
            FileUtils.copyDirectory((File)new File(cluster.getJournalDir()), (File)journalDst);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            cluster.destroy();
        }
        System.out.printf("Artifacts successfully generated at %s and %s%n", journalDst.getAbsolutePath(), backupDst.getAbsolutePath());
    }
}

