/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.grpc.SetAclAction;
import alluxio.master.backcompat.FsTestOp;
import alluxio.master.backcompat.Version;
import alluxio.security.authorization.AclEntry;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public final class SetAcl
extends FsTestOp {
    private static final AlluxioURI DIR_SET = new AlluxioURI("/dirToSetAcl");
    private static final String ACL_STRING = "group:testgroup:rwx";
    private static final AlluxioURI DIR_ADD_REMOVE = new AlluxioURI("/dirToAddRemoveAcl");

    @Override
    public void apply(FileSystem fs) throws Exception {
        fs.createDirectory(DIR_SET);
        fs.setAcl(DIR_SET, SetAclAction.MODIFY, Arrays.asList(AclEntry.fromCliString((String)ACL_STRING)));
        fs.createDirectory(DIR_ADD_REMOVE);
        fs.setAcl(DIR_ADD_REMOVE, SetAclAction.MODIFY, Arrays.asList(AclEntry.fromCliString((String)ACL_STRING)));
        fs.setAcl(DIR_ADD_REMOVE, SetAclAction.REMOVE, Arrays.asList(AclEntry.fromCliString((String)ACL_STRING)));
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        Assert.assertThat((Object)fs.getStatus(DIR_SET).getAcl().toString(), (Matcher)CoreMatchers.containsString((String)ACL_STRING));
        Assert.assertThat((Object)fs.getStatus(DIR_ADD_REMOVE).getAcl().toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)ACL_STRING)));
    }

    @Override
    public boolean supportsVersion(Version version) {
        return version.compareTo(new Version(1, 9, 0)) >= 0;
    }
}

