/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.grpc.SetAttributePOptions;
import alluxio.master.backcompat.FsTestOp;
import alluxio.master.backcompat.Utils;
import org.junit.Assert;

public final class PersistDirectory
extends FsTestOp {
    private static final AlluxioURI DIR = new AlluxioURI("/dirToPersist");
    private static final AlluxioURI INNER_FILE = new AlluxioURI("/dirToPersist/innerFile");

    @Override
    public void apply(FileSystem fs) throws Exception {
        fs.createDirectory(DIR);
        Utils.createFile(fs, INNER_FILE);
        fs.setAttribute(INNER_FILE, SetAttributePOptions.newBuilder().setPersisted(true).build());
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        Assert.assertTrue((boolean)fs.getStatus(DIR).isPersisted());
        Assert.assertTrue((boolean)fs.getStatus(INNER_FILE).isPersisted());
    }
}

