/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat;

import com.google.common.base.Objects;

public final class Version
implements Comparable<Version> {
    private final int mMajor;
    private final int mMinor;
    private final int mPatch;

    public Version(int major, int minor, int patch) {
        this.mMajor = major;
        this.mMinor = minor;
        this.mPatch = patch;
    }

    @Override
    public int compareTo(Version o) {
        if (this.mMajor != o.mMajor) {
            return this.mMajor - o.mMajor;
        }
        if (this.mMinor != o.mMinor) {
            return this.mMinor - o.mMinor;
        }
        if (this.mPatch != o.mPatch) {
            return this.mPatch - o.mPatch;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mMajor, this.mMinor, this.mPatch});
    }

    public String toString() {
        return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mPatch);
    }
}

