/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.SystemOutRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.master.SingleMasterInquireClient;
import alluxio.master.journal.JournalType;
import alluxio.master.journal.raft.RaftJournalSystem;
import alluxio.master.journal.raft.RaftJournalUtils;
import alluxio.master.journal.tool.JournalTool;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.PathUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.server.storage.StorageImplUtils;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="Jiacheng", comment="journal no longer exists in dora")
public class JournalToolTest
extends BaseIntegrationTest {
    private static final int CHECKPOINT_SIZE = 100;
    private final ByteArrayOutputStream mOutput = new ByteArrayOutputStream();
    @Rule
    public SystemOutRule mSystemOutRule = new SystemOutRule((OutputStream)this.mOutput);
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.UFS).setProperty(PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, 100).setProperty(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, "100").setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.MUST_CACHE).build();
    private File mDumpDir;
    private FileSystem mFs;

    @Before
    public void before() throws IOException {
        this.mDumpDir = AlluxioTestDirectory.createTemporaryDirectory((String)"journal_dump");
        this.mFs = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @Test
    public void dumpSimpleUfsJournal() throws Throwable {
        this.mFs.createDirectory(new AlluxioURI("/test"));
        JournalTool.main((String[])new String[]{"-outputDir", this.mDumpDir.getAbsolutePath()});
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)Matchers.containsString((String)this.mDumpDir.getAbsolutePath()));
        this.assertNonemptyFileExists(PathUtils.concatPath((Object)this.mDumpDir, (Object)"edits.txt"));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.journal.type", "EMBEDDED"})
    public void dumpSimpleEmbeddedJournal() throws Throwable {
        this.mFs.createDirectory(new AlluxioURI("/test"));
        this.mLocalAlluxioClusterResource.get().stopMasters();
        String masterJournalPath = this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getJournalFolder();
        JournalTool.main((String[])new String[]{"-inputDir", masterJournalPath, "-outputDir", this.mDumpDir.getAbsolutePath()});
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)Matchers.containsString((String)this.mDumpDir.getAbsolutePath()));
        this.assertNonemptyFileExists(PathUtils.concatPath((Object)this.mDumpDir, (Object)"edits.txt"));
    }

    @Test
    public void dumpHeapCheckpointFromUfsJournal() throws Throwable {
        for (String name : Arrays.asList("/pin", "/max_replication", "/async_persist", "/ttl")) {
            this.mFs.createFile(new AlluxioURI(name)).close();
        }
        this.mFs.setAttribute(new AlluxioURI("/pin"), SetAttributePOptions.newBuilder().setPinned(true).build());
        this.mFs.setAttribute(new AlluxioURI("/max_replication"), SetAttributePOptions.newBuilder().setReplicationMax(5).build());
        this.mFs.persist(new AlluxioURI("/async_persist"));
        this.mFs.setAttribute(new AlluxioURI("/ttl"), SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(100000L).build()).build());
        this.checkpointUfsJournal();
        JournalTool.main((String[])new String[]{"-outputDir", this.mDumpDir.getAbsolutePath()});
        String checkpointDir = this.findCheckpointDir();
        this.assertNonemptyFileExists(PathUtils.concatPath((Object)this.mDumpDir, (Object)"edits.txt"));
        this.assertNonemptyFileExists(PathUtils.concatPath((Object)checkpointDir, (Object)"INODE_DIRECTORY_ID_GENERATOR"));
        for (String subPath : Arrays.asList("INODE_COUNTER", "PINNED_INODE_FILE_IDS", "REPLICATION_LIMITED_FILE_IDS", "TO_BE_PERSISTED_FILE_IDS")) {
            this.assertNonemptyFileExists(PathUtils.concatPath((Object)checkpointDir, (Object[])new Object[]{"INODE_TREE", subPath}));
        }
    }

    @Test
    public void dumpBlockMasterCheckpointFromUfsJournal() throws Throwable {
        this.blockMasterCheckpointUfsJournal();
        JournalTool.main((String[])new String[]{"-outputDir", this.mDumpDir.getAbsolutePath(), "-master", "BlockMaster"});
        this.assertNonemptyFileWithPrefixExist(this.mDumpDir, "checkpoints");
    }

    private void assertNonemptyFileWithPrefixExist(File parent, String prefix) {
        File[] files = parent.listFiles();
        Assert.assertNotNull((Object)files);
        List checkpointFiles = Arrays.stream(files).filter(File::isFile).filter(file -> file.getName().startsWith(prefix)).collect(Collectors.toList());
        Assert.assertFalse((boolean)checkpointFiles.isEmpty());
    }

    private void blockMasterCheckpointUfsJournal() throws Exception {
        for (int i = 0; i < 200; ++i) {
            FileOutStream out = this.mFs.createFile(new AlluxioURI("/" + i));
            out.write(new byte[1]);
            out.close();
        }
        IntegrationTestUtils.waitForUfsJournalCheckpoint("BlockMaster");
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.journal.type", "EMBEDDED", "alluxio.master.metastore", "HEAP"})
    public void dumpHeapCheckpointFromEmbeddedJournal() throws Throwable {
        for (String name : Arrays.asList("/pin", "/max_replication", "/async_persist", "/ttl")) {
            this.mFs.createFile(new AlluxioURI(name)).close();
        }
        this.mFs.setAttribute(new AlluxioURI("/pin"), SetAttributePOptions.newBuilder().setPinned(true).build());
        this.mFs.setAttribute(new AlluxioURI("/max_replication"), SetAttributePOptions.newBuilder().setReplicationMax(5).build());
        this.mFs.persist(new AlluxioURI("/async_persist"));
        this.mFs.setAttribute(new AlluxioURI("/ttl"), SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(100000L).build()).build());
        this.checkpointEmbeddedJournal();
        this.mLocalAlluxioClusterResource.get().stopMasters();
        long snapshotIdxTarget = 250L;
        long currentSnapshotIdx = this.getCurrentRatisSnapshotIndex(this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getJournalFolder());
        Assert.assertTrue((String)"snapshot should be beyond target", (currentSnapshotIdx >= 250L ? 1 : 0) != 0);
        String leaderJournalDir = this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getJournalFolder();
        JournalTool.main((String[])new String[]{"-inputDir", leaderJournalDir, "-outputDir", this.mDumpDir.getAbsolutePath()});
        String checkpointDir = this.findCheckpointDir();
        for (String subPath : Arrays.asList("HEAP_INODE_STORE", "INODE_COUNTER", "PINNED_INODE_FILE_IDS", "REPLICATION_LIMITED_FILE_IDS", "TO_BE_PERSISTED_FILE_IDS", "INODE_DIRECTORY_ID_GENERATOR")) {
            this.assertNonemptyFileExists(PathUtils.concatPath((Object)checkpointDir, (Object)subPath));
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.metastore", "ROCKS"})
    public void dumpRocksCheckpointFromUfsJournal() throws Throwable {
        this.checkpointUfsJournal();
        JournalTool.main((String[])new String[]{"-outputDir", this.mDumpDir.getAbsolutePath()});
        String checkpointDir = this.findCheckpointDir();
        this.assertNonemptyFileExists(PathUtils.concatPath((Object)checkpointDir, (Object[])new Object[]{"INODE_TREE", "CACHING_INODE_STORE"}));
    }

    private void checkpointUfsJournal() throws Exception {
        for (int i = 0; i < 200; ++i) {
            this.mFs.createFile(new AlluxioURI("/" + i)).close();
        }
        IntegrationTestUtils.waitForUfsJournalCheckpoint("FileSystemMaster");
    }

    private void checkpointEmbeddedJournal() throws Throwable {
        for (int i = 0; i < 200; ++i) {
            this.mFs.createFile(new AlluxioURI("/" + i)).close();
        }
        new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient((MasterInquireClient)new SingleMasterInquireClient(this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getAddress())).build()).checkpoint();
    }

    private long getCurrentRatisSnapshotIndex(String journalFolder) throws Throwable {
        try (RaftStorageImpl storage = StorageImplUtils.newRaftStorage((File)new File(RaftJournalUtils.getRaftJournalDir((File)new File(journalFolder)), RaftJournalSystem.RAFT_GROUP_UUID.toString()), (RaftServerConfigKeys.Log.CorruptionPolicy)RaftServerConfigKeys.Log.CorruptionPolicy.getDefault(), (RaftStorage.StartupOption)RaftStorage.StartupOption.RECOVER, (long)RaftServerConfigKeys.STORAGE_FREE_SPACE_MIN_DEFAULT.getSize());){
            storage.initialize();
            SimpleStateMachineStorage stateMachineStorage = new SimpleStateMachineStorage();
            stateMachineStorage.init((RaftStorage)storage);
            SingleFileSnapshotInfo snapshot = stateMachineStorage.getLatestSnapshot();
            if (snapshot == null) {
                throw new IOException("Failed to find a valid snapshot");
            }
            long l = snapshot.getIndex();
            return l;
        }
    }

    private String findCheckpointDir() throws IOException {
        List checkpoint = Files.list(this.mDumpDir.toPath()).filter(p -> p.toString().contains("checkpoints-")).collect(Collectors.toList());
        Assert.assertEquals((String)("Unexpected checkpoint list: " + checkpoint), (long)1L, (long)checkpoint.size());
        return ((Path)checkpoint.get(0)).toString();
    }

    private void assertNonemptyFileExists(String s) {
        File f = new File(s);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isFile());
        Assert.assertThat((Object)f.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    private void assertNonemptyDirExists(String s) {
        File f = new File(s);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isDirectory());
        Assert.assertThat((Object)f.list().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

