/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs;

import alluxio.cli.docgen.ConfigurationDocGenerator;
import alluxio.collections.Pair;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.io.PathUtils;
import com.google.common.base.Joiner;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConfigurationDocGeneratorTest {
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    @Parameterized.Parameter
    public TYPE mFileType;
    @Parameterized.Parameter(value=1)
    public Pair<PropertyKey, String> mTestConf;
    private String mLocation;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({TYPE.CSV, new Pair((Object)PropertyKey.HOME, (Object)"common-configuration.csv")}, {TYPE.CSV, new Pair((Object)PropertyKey.USER_LOCAL_READER_CHUNK_SIZE_BYTES, (Object)"user-configuration.csv")}, {TYPE.CSV, new Pair((Object)PropertyKey.MASTER_WEB_PORT, (Object)"master-configuration.csv")}, {TYPE.CSV, new Pair((Object)PropertyKey.WORKER_DATA_FOLDER, (Object)"worker-configuration.csv")}, {TYPE.CSV, new Pair((Object)PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)"security-configuration.csv")}, {TYPE.YML, new Pair((Object)PropertyKey.HOME, (Object)"common-configuration.yml")}, {TYPE.YML, new Pair((Object)PropertyKey.USER_LOCAL_READER_CHUNK_SIZE_BYTES, (Object)"user-configuration.yml")}, {TYPE.YML, new Pair((Object)PropertyKey.MASTER_WEB_PORT, (Object)"master-configuration.yml")}, {TYPE.YML, new Pair((Object)PropertyKey.WORKER_DATA_FOLDER, (Object)"worker-configuration.yml")}, {TYPE.YML, new Pair((Object)PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)"security-configuration.yml")});
    }

    @Before
    public void before() throws Exception {
        this.mLocation = this.mFolder.newFolder().toString();
    }

    private void checkFileContents(String source, List<String> target, TYPE fType) throws Exception {
        Assert.assertTrue((fType.equals((Object)TYPE.CSV) || fType.equals((Object)TYPE.YML) ? 1 : 0) != 0);
        if (fType == TYPE.CSV) {
            Assert.assertEquals((long)2L, (long)target.size());
            Assert.assertEquals((Object)"propertyName,defaultValue", (Object)target.get(0));
            Assert.assertEquals((Object)source, (Object)target.get(1));
        } else if (fType == TYPE.YML) {
            Assert.assertEquals((long)(StringUtils.countMatches((CharSequence)source, (CharSequence)"\n") + 1), (long)target.size());
            Assert.assertEquals((Object)source, (Object)Joiner.on((String)"\n").join(target));
        }
    }

    @Test
    public void checkCSVFile() throws Exception {
        if (this.mFileType != TYPE.CSV) {
            return;
        }
        ArrayList<PropertyKey> defaultKeys = new ArrayList<PropertyKey>();
        PropertyKey pKey = (PropertyKey)this.mTestConf.getFirst();
        defaultKeys.add(pKey);
        ConfigurationDocGenerator.writeCSVFile(defaultKeys, (String)this.mLocation);
        String filePath = PathUtils.concatPath((Object)this.mLocation, (Object)this.mTestConf.getSecond());
        Path p = Paths.get(filePath, new String[0]);
        Assert.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
        List<String> userFile = Files.readAllLines(p, StandardCharsets.UTF_8);
        Object defaultValue = Configuration.get((PropertyKey)pKey);
        this.checkFileContents(String.format("%s,\"%s\"", pKey, defaultValue), userFile, this.mFileType);
    }

    @Test
    public void checkYMLFile() throws Exception {
        if (this.mFileType != TYPE.YML) {
            return;
        }
        ArrayList<PropertyKey> defaultKeys = new ArrayList<PropertyKey>();
        PropertyKey pKey = (PropertyKey)this.mTestConf.getFirst();
        String description = pKey.getDescription();
        defaultKeys.add(pKey);
        ConfigurationDocGenerator.writeYMLFile(defaultKeys, (String)this.mLocation);
        String filePath = PathUtils.concatPath((Object)this.mLocation, (Object)this.mTestConf.getSecond());
        Path p = Paths.get(filePath, new String[0]);
        Assert.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
        List<String> keyDescription = Files.readAllLines(p, StandardCharsets.UTF_8);
        String expected = pKey + ":\n  '" + description.replace("'", "''") + "'";
        this.checkFileContents(expected, keyDescription, this.mFileType);
    }

    static enum TYPE {
        CSV,
        YML;

    }
}

