/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.WritePType;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="Jiacheng", comment="need to check if this command will still exist in Dora")
public class CheckConsistencyCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void consistent() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.CACHE_THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.CACHE_THROUGH, (int)20);
        sFsShell.run(new String[]{"checkConsistency", "/testRoot"});
        String expected = "/testRoot is consistent with the under storage system.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        this.mOutput.reset();
        sFsShell.run(new String[]{"checkConsistency", "-r", "/testRoot"});
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void inconsistent() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.CACHE_THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.CACHE_THROUGH, (int)20);
        String ufsPath = sFileSystem.getStatus(new AlluxioURI("/testRoot/testDir")).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        ufs.deleteDirectory(ufsPath, DeleteOptions.defaults().setRecursive(true));
        sFsShell.run(new String[]{"checkConsistency", "/testRoot"});
        StringBuilder expected = new StringBuilder();
        expected.append("The following files are inconsistent:\n");
        expected.append("/testRoot/testDir\n");
        expected.append("/testRoot/testDir/testFileB\n");
        Assert.assertEquals((Object)expected.toString(), (Object)this.mOutput.toString());
        this.mOutput.reset();
        sFsShell.run(new String[]{"checkConsistency", "-r", "/testRoot"});
        String res = this.mOutput.toString();
        Assert.assertTrue((res.contains("/testRoot has: 2 inconsistent files.") && res.contains("repairing path: /testRoot/testDir\n") && res.contains("repairing path: /testRoot/testDir/testFileB\n") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/testRoot/testDir")));
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/testRoot/testDir/testFileB")));
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.CACHE_THROUGH, (int)20);
        ufsPath = sFileSystem.getStatus(new AlluxioURI("/testRoot/testDir/testFileB")).getUfsPath();
        ufs.deleteFile(ufsPath);
        OutputStream outputStream = ufs.create(ufsPath);
        byte[] bytes = new byte[]{1, 2, 3};
        outputStream.write(bytes);
        outputStream.close();
        this.mOutput.reset();
        sFsShell.run(new String[]{"checkConsistency", "-r", "/testRoot"});
        res = this.mOutput.toString();
        Assert.assertTrue((res.contains("/testRoot has: 1 inconsistent files.") && res.contains("repairing path: /testRoot/testDir/testFileB\n") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/testRoot/testDir/testFileB"), ExistsPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).build()));
        Assert.assertEquals((long)3L, (long)sFileSystem.getStatus(new AlluxioURI("/testRoot/testDir/testFileB")).getLength());
    }

    @Test
    public void testExistInAlluxioButNotInUfs() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.CACHE_THROUGH, (int)10);
        String ufsPath = sFileSystem.getStatus(new AlluxioURI("/testRoot")).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        ufs.deleteFile(sFileSystem.getStatus(new AlluxioURI("/testRoot/testFileA")).getUfsPath());
        sFsShell.run(new String[]{"checkConsistency", "/testRoot"});
        String res = this.mOutput.toString();
        Assert.assertTrue((res.contains("The following files are inconsistent") && res.contains("/testRoot/testFileA") ? 1 : 0) != 0);
        this.mOutput.reset();
        sFsShell.run(new String[]{"checkConsistency", "-r", "/testRoot"});
        res = this.mOutput.toString();
        Assert.assertTrue((res.contains("/testRoot has: 1 inconsistent files") && res.contains("repairing path: /testRoot/testFileA") && res.contains("/testRoot/testFileA repaired") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/testRoot/testFileA")));
    }

    @Test
    public void wildcard() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir2/testFileA", (WritePType)WritePType.CACHE_THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.CACHE_THROUGH, (int)20);
        sFsShell.run(new String[]{"checkConsistency", "/testRoot/*/testFile*"});
        String expected = "/testRoot/testDir/testFileB is consistent with the under storage system.\n/testRoot/testDir2/testFileA is consistent with the under storage system.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void multiThreaded() throws Exception {
        this.makeInconsistentFiles("/testRoot", 1);
        sFsShell.run("checkConsistency -r -t 1 /testRoot".split(" "));
        String res = this.mOutput.toString();
        Assert.assertTrue((boolean)res.contains("Repairing with 1 threads."));
        this.mOutput.reset();
        this.makeInconsistentFiles("/testRoot", 2);
        sFsShell.run("checkConsistency -r -t 2 /testRoot".split(" "));
        res = this.mOutput.toString();
        Assert.assertTrue((boolean)res.contains("Repairing with 2 threads."));
    }

    void makeInconsistentFiles(String rootDir, int nFiles) throws AlluxioException, IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        for (int i = 0; i < nFiles; ++i) {
            filenames.add(String.format("%s/testDir/testFile%d", rootDir, i));
        }
        filenames.forEach(path -> FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)path, (WritePType)WritePType.CACHE_THROUGH, (int)10));
        String ufsPath = sFileSystem.getStatus(new AlluxioURI("/testRoot/testDir")).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        ufs.deleteDirectory(ufsPath, DeleteOptions.defaults().setRecursive(true));
    }
}

