/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.ConfigurationRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="Jiacheng", comment="need to check if this command will still exist in Dora")
public final class ChownCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Rule
    public ConfigurationRule mConfiguration = new ConfigurationRule((Map)ImmutableMap.of((Object)PropertyKey.SECURITY_GROUP_MAPPING_CLASS, (Object)AbstractFileSystemShellTest.FakeUserGroupsMapping.class.getName()), Configuration.modifiableGlobal());

    @Test
    public void chown() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chown", TEST_USER_1.getUser(), "/testFile"});
        String owner = sFileSystem.getStatus(new AlluxioURI("/testFile")).getOwner();
        Assert.assertEquals((Object)TEST_USER_1.getUser(), (Object)owner);
        sFsShell.run(new String[]{"chown", TEST_USER_2.getUser(), "/testFile"});
        owner = sFileSystem.getStatus(new AlluxioURI("/testFile")).getOwner();
        Assert.assertEquals((Object)TEST_USER_2.getUser(), (Object)owner);
    }

    @Test
    public void chownValidOwnerValidGroupSuccess() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        String newOwner = TEST_USER_1.getUser();
        String group = "staff";
        String expectedCommandOutput = "Changed owner:group of /testFile to " + newOwner + ":" + group + ".";
        this.verifyCommandReturnValueAndOutput(0, expectedCommandOutput, "chown", newOwner + ":" + group, "/testFile");
        this.checkPathOwnerAndGroup("/testFile", newOwner, group);
    }

    @Test
    public void chownValidOwnerValidGroupFail() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        String newOwner = TEST_USER_2.getUser();
        String originalOwner = sFileSystem.getStatus(new AlluxioURI("/testFile")).getOwner();
        String originalGroup = sFileSystem.getStatus(new AlluxioURI("/testFile")).getGroup();
        String group = "alice";
        String expectedCommandOutput = String.format("Could not update owner:group for /testFile to %s:%s", newOwner, group);
        this.verifyCommandReturnValueAndOutput(-1, expectedCommandOutput, "chown", newOwner + ":" + group, "/testFile");
        this.checkPathOwnerAndGroup("/testFile", originalOwner, originalGroup);
    }

    @Test
    public void chownInvalidOwnerValidGroup() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        String nonexistUser = "nonexistuser";
        String originalOwner = sFileSystem.getStatus(new AlluxioURI("/testFile")).getOwner();
        String originalGroup = sFileSystem.getStatus(new AlluxioURI("/testFile")).getGroup();
        String group = "staff";
        String expectedCommandOutput = String.format("Could not update owner:group for /testFile to %s:%s", nonexistUser, group);
        this.verifyCommandReturnValueAndOutput(-1, expectedCommandOutput, "chown", nonexistUser + ":" + group, "/testFile");
        this.checkPathOwnerAndGroup("/testFile", originalOwner, originalGroup);
    }

    @Test
    public void chownValidOwnerInvalidGroup() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        String newOwner = TEST_USER_1.getUser();
        String nonexistGroup = "nonexistgroup";
        String originalOwner = sFileSystem.getStatus(new AlluxioURI("/testFile")).getOwner();
        String originalGroup = sFileSystem.getStatus(new AlluxioURI("/testFile")).getGroup();
        String expectedCommandOutput = String.format("Could not update owner:group for /testFile to %s:%s", newOwner, nonexistGroup);
        this.verifyCommandReturnValueAndOutput(-1, expectedCommandOutput, "chown", newOwner + ":" + nonexistGroup, "/testFile");
        this.checkPathOwnerAndGroup("/testFile", originalOwner, originalGroup);
    }

    @Test
    public void chownInvalidOwnerInvalidGroup() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        String nonexistUser = "nonexistuser";
        String nonexistGroup = "nonexistgroup";
        String originalOwner = sFileSystem.getStatus(new AlluxioURI("/testFile")).getOwner();
        String originalGroup = sFileSystem.getStatus(new AlluxioURI("/testFile")).getGroup();
        String expectedCommandOutput = String.format("Could not update owner:group for /testFile to %s:%s", nonexistUser, nonexistGroup);
        this.verifyCommandReturnValueAndOutput(-1, expectedCommandOutput, "chown", nonexistUser + ":" + nonexistGroup, "/testFile");
        this.checkPathOwnerAndGroup("/testFile", originalOwner, originalGroup);
    }

    @Test
    public void chownRecursive() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chown", "-R", TEST_USER_1.getUser(), "/testDir"});
        String owner = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile")).getOwner();
        Assert.assertEquals((Object)TEST_USER_1.getUser(), (Object)owner);
        owner = sFileSystem.getStatus(new AlluxioURI("/testDir")).getOwner();
        Assert.assertEquals((Object)TEST_USER_1.getUser(), (Object)owner);
        sFsShell.run(new String[]{"chown", "-R", TEST_USER_2.getUser(), "/testDir"});
        owner = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile")).getOwner();
        Assert.assertEquals((Object)TEST_USER_2.getUser(), (Object)owner);
    }

    @Test
    public void chownWildcard() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/testFile1", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir2/testFile2", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chown", "-R", TEST_USER_1.getUser(), "/*/testFile*"});
        String owner = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile1")).getOwner();
        Assert.assertEquals((Object)TEST_USER_1.getUser(), (Object)owner);
        owner = sFileSystem.getStatus(new AlluxioURI("/testDir2/testFile2")).getOwner();
        Assert.assertEquals((Object)TEST_USER_1.getUser(), (Object)owner);
    }

    private void checkPathOwnerAndGroup(String path, String expectedOwner, String expectedGroup) throws Exception {
        String currentOwner = sFileSystem.getStatus(new AlluxioURI(path)).getOwner();
        String currentGroup = sFileSystem.getStatus(new AlluxioURI(path)).getGroup();
        Assert.assertEquals((Object)expectedOwner, (Object)currentOwner);
        Assert.assertEquals((Object)expectedGroup, (Object)currentGroup);
    }
}

