/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.ConfigurationRule;
import alluxio.SystemPropertyRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileInStream;
import alluxio.client.file.URIStatus;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="the command is still relevant")
public final class CopyFromLocalCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Rule
    public TemporaryFolder mTestFolder = new TemporaryFolder();

    @Test
    public void copyFromLocalFileToDstPath() throws IOException, AlluxioException {
        String dataString = "copyFromLocalFileToDstPathTest";
        byte[] data = dataString.getBytes();
        File localDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/localDir");
        localDir.mkdir();
        File localFile = this.generateFileContent("/localDir/testFile", data);
        sFsShell.run(new String[]{"mkdir", "/dstDir"});
        sFsShell.run(new String[]{"copyFromLocal", localFile.getPath(), "/dstDir"});
        AlluxioURI uri = new AlluxioURI("/dstDir/testFile");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertNotNull((Object)status);
        byte[] read = this.readContent(uri, data.length);
        Assert.assertEquals((Object)new String(read), (Object)dataString);
    }

    @Test
    public void copyFromLocalDir() throws IOException, AlluxioException {
        File srcOuterDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir");
        File srcInnerDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/innerDir");
        File emptyDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/emptyDir");
        srcOuterDir.mkdir();
        srcInnerDir.mkdir();
        emptyDir.mkdir();
        this.generateFileContent("/outerDir/srcFile1", BufferUtils.getIncreasingByteArray((int)10));
        this.generateFileContent("/outerDir/innerDir/srcFile2", BufferUtils.getIncreasingByteArray((int)10));
        int ret = sFsShell.run(new String[]{"copyFromLocal", srcOuterDir.getPath() + "/", "/dstDir"});
        Assert.assertEquals((long)0L, (long)ret);
        AlluxioURI dstURI1 = new AlluxioURI("/dstDir/srcFile1");
        AlluxioURI dstURI2 = new AlluxioURI("/dstDir/innerDir/srcFile2");
        AlluxioURI dstURI3 = new AlluxioURI("/dstDir/emptyDir");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI1));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI2));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI3));
    }

    @Test
    public void copyFromLocalDirToExistingFile() throws IOException, AlluxioException {
        File localDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/localDir");
        File innerDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/localDir/innerDir");
        localDir.mkdir();
        innerDir.mkdir();
        this.generateFileContent("/localDir/srcFile", BufferUtils.getIncreasingByteArray((int)10));
        sFileSystem.createFile(new AlluxioURI("/dstFile")).close();
        int ret = sFsShell.run(new String[]{"copyFromLocal", localDir.getPath(), "/dstFile"});
        Assert.assertEquals((long)-1L, (long)ret);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI("/dstFile")).isFolder());
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/dstFile/innerDir")));
    }

    @Test
    public void copyFromLocalDirToExistingDir() throws IOException, AlluxioException {
        File srcOuterDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir");
        File srcInnerDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/innerDir");
        File emptyDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/emptyDir");
        srcOuterDir.mkdir();
        srcInnerDir.mkdir();
        emptyDir.mkdir();
        this.generateFileContent("/outerDir/srcFile1", BufferUtils.getIncreasingByteArray((int)10));
        this.generateFileContent("/outerDir/innerDir/srcFile2", BufferUtils.getIncreasingByteArray((int)10));
        sFileSystem.createDirectory(new AlluxioURI("/dstDir"));
        int ret = sFsShell.run(new String[]{"copyFromLocal", srcOuterDir.getPath(), "/dstDir"});
        Assert.assertEquals((long)0L, (long)ret);
        AlluxioURI dstURI1 = new AlluxioURI("/dstDir/srcFile1");
        AlluxioURI dstURI2 = new AlluxioURI("/dstDir/innerDir/srcFile2");
        AlluxioURI dstURI3 = new AlluxioURI("/dstDir/emptyDir");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI1));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI2));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI3));
        sFileSystem.createDirectory(new AlluxioURI("/dstDir1"));
        sFileSystem.createDirectory(new AlluxioURI("/dstDir1/innerDir"));
        int ret1 = sFsShell.run(new String[]{"copyFromLocal", srcOuterDir.getPath(), "/dstDir1"});
        Assert.assertEquals((long)-1L, (long)ret1);
        dstURI1 = new AlluxioURI("/dstDir1/srcFile1");
        dstURI2 = new AlluxioURI("/dstDir1/innerDir/srcFile2");
        dstURI3 = new AlluxioURI("/dstDir1/emptyDir");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI1));
        Assert.assertFalse((boolean)sFileSystem.exists(dstURI2));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI3));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.worker.network.netty.watermark.high", "1.0"})
    public void copyFromLocalLarge() throws IOException, AlluxioException {
        File testFile = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testFile");
        testFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(testFile);
        byte[] toWrite = BufferUtils.getIncreasingByteArray((int)0x1000000);
        fos.write(toWrite);
        fos.close();
        sFsShell.run(new String[]{"copyFromLocal", testFile.getAbsolutePath(), "/testFile"});
        Assert.assertEquals((Object)this.getCommandOutput(new String[]{"copyFromLocal", testFile.getAbsolutePath(), "/testFile"}), (Object)this.mOutput.toString());
        AlluxioURI uri = new AlluxioURI("/testFile");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((long)0x1000000L, (long)status.getLength());
        try (FileInStream tfis = sFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build());){
            byte[] read = new byte[0x1000000];
            tfis.read(read);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)0x1000000, (byte[])read));
        }
    }

    @Test
    public void copyFromLocalOverwrite() throws Exception {
        int LEN1 = 10;
        int LEN2 = 20;
        File testFile1 = this.generateFileContent("/testFile1", BufferUtils.getIncreasingByteArray((int)10));
        File testFile2 = this.generateFileContent("/testFile2", BufferUtils.getIncreasingByteArray((int)20));
        AlluxioURI alluxioFilePath = new AlluxioURI("/testFile");
        String[] cmd1 = new String[]{"copyFromLocal", testFile1.getPath(), alluxioFilePath.getPath()};
        sFsShell.run(cmd1);
        Assert.assertEquals((Object)this.getCommandOutput(cmd1), (Object)this.mOutput.toString());
        this.mOutput.reset();
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])this.readContent(alluxioFilePath, 10)));
        String[] cmd2 = new String[]{"copyFromLocal", testFile2.getPath(), alluxioFilePath.getPath()};
        Assert.assertEquals((long)-1L, (long)sFsShell.run(cmd2));
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.CANNOT_OVERWRITE_FILE_WITHOUT_OVERWRITE.getMessage(new Object[]{alluxioFilePath.getPath()})));
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])this.readContent(alluxioFilePath, 10)));
    }

    @Test
    public void copyFromLocalDirectoryNotExist() throws Exception {
        int LEN = 10;
        File testFile1 = this.generateFileContent("/testFile1", BufferUtils.getIncreasingByteArray((int)10));
        String dirPath = "/testDir-notExist/";
        AlluxioURI alluxioFilePath = new AlluxioURI(dirPath);
        String[] cmd = new String[]{"copyFromLocal", testFile1.getPath(), dirPath};
        Assert.assertEquals((long)-1L, (long)sFsShell.run(cmd));
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.CANNOT_COPY_TO_NOT_EXIST_DIRECTORY.getMessage(new Object[]{alluxioFilePath.getPath()})));
    }

    @Test
    public void copyFromLocalTypeNotMatch() throws Exception {
        int LEN = 10;
        String path = "/testFile1";
        File testFile1 = this.generateFileContent(path, BufferUtils.getIncreasingByteArray((int)10));
        AlluxioURI alluxioFilePath = new AlluxioURI(path);
        String[] cmd1 = new String[]{"copyFromLocal", testFile1.getPath(), alluxioFilePath.getPath()};
        Assert.assertEquals((long)0L, (long)sFsShell.run(cmd1));
        this.mOutput.reset();
        String[] cmd2 = new String[]{"copyFromLocal", testFile1.getPath(), alluxioFilePath.getPath() + "/"};
        Assert.assertEquals((long)-1L, (long)sFsShell.run(cmd2));
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.FILE_TYPE_NOT_MATCH.getMessage(new Object[]{alluxioFilePath.getPath()})));
    }

    @Test
    public void copyFromLocal() throws IOException, AlluxioException {
        File testDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir");
        testDir.mkdir();
        File testDirInner = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir/testDirInner");
        testDirInner.mkdir();
        File testFile = this.generateFileContent("/testDir/testFile", BufferUtils.getIncreasingByteArray((int)10));
        this.generateFileContent("/testDir/testDirInner/testFile2", BufferUtils.getIncreasingByteArray((int)10, (int)20));
        sFsShell.run(new String[]{"copyFromLocal", testFile.getParent(), "/testDir"});
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)this.getCommandOutput(new String[]{"copyFromLocal", testFile.getParent(), "/testDir"})));
        AlluxioURI uri1 = new AlluxioURI("/testDir/testFile");
        AlluxioURI uri2 = new AlluxioURI("/testDir/testDirInner/testFile2");
        URIStatus status1 = sFileSystem.getStatus(uri1);
        URIStatus status2 = sFileSystem.getStatus(uri2);
        Assert.assertNotNull((Object)status1);
        Assert.assertNotNull((Object)status2);
        Assert.assertEquals((long)10L, (long)status1.getLength());
        Assert.assertEquals((long)20L, (long)status2.getLength());
        byte[] read = this.readContent(uri1, 10);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])read));
        read = this.readContent(uri2, 20);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)20, (byte[])read));
    }

    @Test
    public void copyFromLocalMustCacheThenCacheThrough() throws Exception {
        File file = this.mTestFolder.newFile();
        try (Closeable c = new ConfigurationRule(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)WriteType.MUST_CACHE.toString(), Configuration.modifiableGlobal()).toResource();){
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"copyFromLocal", file.getAbsolutePath(), "/test"}));
        }
        c = new ConfigurationRule(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)WriteType.CACHE_THROUGH.toString(), Configuration.modifiableGlobal()).toResource();
        var3_3 = null;
        try {
            this.mOutput.reset();
            sFsShell.run(new String[]{"copyFromLocal", file.getAbsolutePath(), "/test"});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var3_3 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.CANNOT_OVERWRITE_FILE_WITHOUT_OVERWRITE.getMessage(new Object[]{"/test"})));
    }

    @Test
    public void copyFromLocalTestWithFullURI() throws IOException, AlluxioException {
        File testFile = this.generateFileContent("/srcFileURI", BufferUtils.getIncreasingByteArray((int)10));
        String alluxioURI = "alluxio://" + sLocalAlluxioCluster.getHostname() + ":" + sLocalAlluxioCluster.getMasterRpcPort() + "/destFileURI";
        sFsShell.run(new String[]{"copyFromLocal", testFile.getPath(), alluxioURI});
        String cmdOut = this.getCommandOutput(new String[]{"copyFromLocal", testFile.getPath(), alluxioURI});
        Assert.assertEquals((Object)cmdOut, (Object)this.mOutput.toString());
        AlluxioURI uri = new AlluxioURI("/destFileURI");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertEquals((long)10L, (long)status.getLength());
        byte[] read = this.readContent(uri, 10);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])read));
    }

    @Test
    public void copyFromLocalWildcardExistingDir() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"copyFromLocal", testDir + "/*/foo*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar1")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar3")));
    }

    @Test
    public void copyFromLocalWildcardHier() throws IOException {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        int ret = sFsShell.run(new String[]{"copyFromLocal", testDir + "/*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foo/foobar1")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foo/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/bar/foobar3")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar4")));
    }

    @Test
    public void copyFromLocalWildcardNotDir() throws IOException, AlluxioException {
        String localTestDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        String alluxioTestDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"copyFromLocal", localTestDir + "/*/foo*", alluxioTestDir + "/foobar4"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void copyFromLocalWildcard() throws IOException {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        int ret = sFsShell.run(new String[]{"copyFromLocal", testDir + "/*/foo*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar1")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar3")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI("/testDir/foobar4")));
    }

    @Test
    public void copyFromLocalRelativePath() throws Exception {
        String version = System.getProperty("java.version");
        if (version.startsWith("11")) {
            return;
        }
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("user.dir", this.mTestFolder.getRoot().getAbsolutePath());
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            File localDir = this.mTestFolder.newFolder("testDir");
            this.generateRelativeFileContent(localDir.getPath() + "/testFile", BufferUtils.getIncreasingByteArray((int)10));
            int ret = sFsShell.run(new String[]{"copyFromLocal", "testDir/testFile", "/testFile"});
            Assert.assertEquals((long)0L, (long)ret);
            Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testFile")));
        }
    }

    @Test(timeout=30000L)
    public void copyFromLargeLocalDirectory() throws Exception {
        String testDir = "/testDir";
        String filePathFormat = "file_%d";
        File src = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir");
        FileUtils.deleteDirectory((File)src);
        src.mkdir();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        int numFiles = 2000;
        int i = 0;
        while (i < 2000) {
            int fileId = i++;
            executor.submit(() -> {
                try {
                    new File(src, String.format("file_%d", fileId)).createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        File[] files = src.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertEquals((long)2000L, (long)files.length);
        AlluxioURI dst = new AlluxioURI("/testDir");
        if (sFileSystem.exists(dst)) {
            sFileSystem.delete(dst, DeletePOptions.newBuilder().setRecursive(true).build());
        }
        sFileSystem.createDirectory(dst);
        int ret = sFsShell.run(new String[]{"copyFromLocal", src.getAbsolutePath(), "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        for (int i2 = 0; i2 < 2000; ++i2) {
            Assert.assertTrue((boolean)this.fileExists(dst.join(String.format("file_%d", i2))));
        }
    }

    @Test
    public void parseOption() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        int ret = sFsShell.run(new String[]{"copyFromLocal", "--thread", "1", "--buffersize", "1024", testDir + "/*/foo*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
    }
}

