/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.SystemPropertyRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.WritePType;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="the command is still relevant")
public final class CopyToLocalCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Rule
    public TemporaryFolder mTestFolder = new TemporaryFolder();

    @Test
    public void copyToLocalDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"copyToLocal", testDir, sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foo/foobar1", 10);
        this.fileReadTest("/testDir/foo/foobar2", 20);
        this.fileReadTest("/testDir/bar/foobar3", 30);
        this.fileReadTest("/testDir/foobar4", 40);
    }

    @Test
    public void copyToLocalRelativePathDir() throws Exception {
        String version = System.getProperty("java.version");
        if (version.startsWith("11")) {
            return;
        }
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("user.dir", this.mTestFolder.getRoot().getAbsolutePath());
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            File localDir = this.mTestFolder.newFolder("localDir");
            localDir.mkdir();
            sFsShell.run(new String[]{"copyToLocal", "/testFile", "localDir"});
            Assert.assertEquals((Object)("Copied /testFile to file://" + this.mTestFolder.getRoot().getAbsolutePath() + "/localDir/testFile\n"), (Object)this.mOutput.toString());
        }
    }

    @Test
    public void copyToLocalLarge() throws Exception {
        this.copyToLocalWithBytes(0x800000);
    }

    @Test
    public void copyToLocal() throws Exception {
        this.copyToLocalWithBytes(10);
    }

    @Test
    public void copyToLocalWildcardExistingDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir").mkdir();
        int ret = sFsShell.run(new String[]{"copyToLocal", testDir + "/*/foo*", sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foobar1", 10);
        this.fileReadTest("/testDir/foobar2", 20);
        this.fileReadTest("/testDir/foobar3", 30);
    }

    @Test
    public void copyToLocalWildcardHier() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"copyToLocal", testDir + "/*", sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foo/foobar1", 10);
        this.fileReadTest("/testDir/foo/foobar2", 20);
        this.fileReadTest("/testDir/bar/foobar3", 30);
        this.fileReadTest("/testDir/foobar4", 40);
    }

    @Test
    public void copyToLocalWildcardNotDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir").mkdir();
        new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir/testFile").createNewFile();
        int ret = sFsShell.run(new String[]{"copyToLocal", testDir + "/*/foo*", sLocalAlluxioCluster.getAlluxioHome() + "/testDir/testFile"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void copyToLocalWildcard() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"copyToLocal", testDir + "/*/foo*", sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foobar1", 10);
        this.fileReadTest("/testDir/foobar2", 20);
        this.fileReadTest("/testDir/foobar3", 30);
    }

    @Test
    public void copyToLocalRelativePath() throws Exception {
        String version = System.getProperty("java.version");
        if (version.startsWith("11")) {
            return;
        }
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("user.dir", this.mTestFolder.getRoot().getAbsolutePath());
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
            sFsShell.run(new String[]{"copyToLocal", "/testFile", "."});
            Assert.assertEquals((Object)("Copied /testFile to file://" + this.mTestFolder.getRoot().getAbsolutePath() + "/testFile\n"), (Object)this.mOutput.toString());
            this.mOutput.reset();
            sFsShell.run(new String[]{"copyToLocal", "/testFile", "./testFile"});
            Assert.assertEquals((Object)("Copied /testFile to file://" + this.mTestFolder.getRoot().getAbsolutePath() + "/testFile\n"), (Object)this.mOutput.toString());
        }
    }

    @Test
    public void parseOption() {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"copyToLocal", "--buffersize", "1024", "/testFile", sLocalAlluxioCluster.getAlluxioHome() + "/testFile"});
        Assert.assertEquals((long)0L, (long)ret);
    }
}

