/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.WritePType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="the command is still relevant")
public final class CountCommandTest
extends AbstractFileSystemShellTest {
    @Test
    public void countNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"count", "/NotExistFile"});
        Assert.assertEquals((Object)(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"/NotExistFile"}) + "\n"), (Object)this.mOutput.toString());
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void count() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileB", (WritePType)WritePType.MUST_CACHE, (int)30);
        sFsShell.run(new String[]{"count", "/testRoot"});
        String expected = "";
        expected = expected + String.format("%-25s%-25s%-15s%n", "File Count", "Folder Count", "Folder Size");
        expected = expected + String.format("%-25s%-25s%-15s%n", 3, 1, 60);
        sFsShell.run(new String[]{"count", "-h", "/testRoot"});
        expected = expected + String.format("%-25s%-25s%-15s%n", "File Count", "Folder Count", "Folder Size");
        expected = expected + String.format("%-25s%-25s%-15s%n", 3, 1, "60B");
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }
}

