/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.ConfigurationRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fs.FileSystemShell;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.Mode;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.master.worker.info.cache.refresh.time", "1ms", "alluxio.user.worker.list.refresh.interval", "1ms"})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="the command is still relevant")
public final class CpCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Rule
    public ConfigurationRule mConfiguration = new ConfigurationRule((Map)ImmutableMap.of((Object)PropertyKey.SECURITY_GROUP_MAPPING_CLASS, (Object)AbstractFileSystemShellTest.FakeUserGroupsMapping.class.getName()), Configuration.modifiableGlobal());

    @Test
    public void copyFileNew() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", testDir + "/foobar4", "/copy"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy"), new AlluxioURI(testDir + "/foobar4")));
    }

    @Test
    public void copyFileExisting() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", testDir + "/foobar4", testDir + "/bar"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + "/bar/foobar4")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI(testDir + "/bar/foobar4"), new AlluxioURI(testDir + "/foobar4")));
    }

    @Test
    public void copyDirNew() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", "-R", testDir, "/copy"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/bar")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/bar/foobar3")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foo")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foo/foobar1")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foo/foobar2")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foobar4")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/bar/foobar3"), new AlluxioURI(testDir + "/bar/foobar3")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/foo/foobar1"), new AlluxioURI(testDir + "/foo/foobar1")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/foo/foobar2"), new AlluxioURI(testDir + "/foo/foobar2")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/foobar4"), new AlluxioURI(testDir + "/foobar4")));
    }

    @Test
    public void copyDirExisting() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", "-R", testDir, testDir});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir)));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir + "/bar")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir + "/bar/foobar3")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir + "/foo")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir + "/foo/foobar1")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir + "/foo/foobar2")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(testDir + testDir + "/foobar4")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI(testDir + testDir + "/bar/foobar3"), new AlluxioURI(testDir + "/bar/foobar3")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI(testDir + testDir + "/foo/foobar1"), new AlluxioURI(testDir + "/foo/foobar1")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI(testDir + testDir + "/foo/foobar2"), new AlluxioURI(testDir + "/foo/foobar2")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI(testDir + testDir + "/foobar4"), new AlluxioURI(testDir + "/foobar4")));
    }

    @Test
    public void copyWildcard() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", testDir + "/*/foo*", "/copy"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foobar1")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foobar2")));
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/copy/foobar3")));
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/copy/foobar4")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/foobar1"), new AlluxioURI(testDir + "/foo/foobar1")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/foobar2"), new AlluxioURI(testDir + "/foo/foobar2")));
        Assert.assertTrue((boolean)this.equals(new AlluxioURI("/copy/foobar3"), new AlluxioURI(testDir + "/bar/foobar3")));
    }

    @Test
    public void copyWildcardWithSpecialCharacters() throws Exception {
        char[] specialChars;
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        for (char specialChar : specialChars = new char[]{'.', '+', '^', '$'}) {
            this.copyWildcardWithSpecialChar(testDir, specialChar);
        }
    }

    private void copyWildcardWithSpecialChar(String testDir, char specialChar) throws Exception {
        String specialFolderName = String.format("%s/folder%sname", testDir, Character.valueOf(specialChar));
        sFsShell.run(new String[]{"mkdir", specialFolderName});
        sFsShell.run(new String[]{"mkdir", "/result"});
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(specialFolderName)));
        sFsShell.run(new String[]{"cp", testDir + "/foobar4", specialFolderName + "/foobar4"});
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI(specialFolderName + "/foobar4")));
        sFsShell.run(new String[]{"cp", specialFolderName + "/*", "/result/"});
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/result/foobar4")));
        sFsShell.run(new String[]{"rm", "/result/foobar4"});
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/result/foobar4")));
    }

    @Test
    public void copyFileWithPreservedAttributes() throws Exception {
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, "MUST_CACHE");
        try (FileSystemShell fsShell = new FileSystemShell((AlluxioConfiguration)conf);){
            String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
            AlluxioURI srcFile = new AlluxioURI(testDir + "/foobar4");
            String owner = TEST_USER_1.getUser();
            String group = "staff";
            short mode = 274;
            ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
            entries.add(new AclEntry.Builder().setType(AclEntryType.NAMED_USER).setSubject(TEST_USER_2.getUser()).addAction(AclAction.READ).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
            entries.add(new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(group).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
            sFileSystem.setAttribute(srcFile, SetAttributePOptions.newBuilder().setOwner(owner).setGroup(group).setMode(new Mode(mode).toProto()).setPinned(true).setReplicationMin(2).setReplicationMax(4).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(12345L)).build());
            sFileSystem.setAcl(srcFile, SetAclAction.MODIFY, entries);
            int ret = fsShell.run(new String[]{"cp", "-p", testDir + "/foobar4", testDir + "/bar"});
            AlluxioURI dstFile = new AlluxioURI(testDir + "/bar/foobar4");
            Assert.assertEquals((long)0L, (long)ret);
            Assert.assertTrue((boolean)sFileSystem.exists(dstFile));
            this.verifyPreservedAttributes(srcFile, dstFile);
        }
    }

    @Test
    public void copyDirectoryWithPreservedAttributes() throws Exception {
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, "MUST_CACHE");
        try (FileSystemShell fsShell = new FileSystemShell((AlluxioConfiguration)conf);){
            String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
            String newDir = "/copy";
            String subDir = "/foo";
            String file = "/foobar4";
            String owner = TEST_USER_1.getUser();
            String group = "staff";
            short mode = 274;
            ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
            entries.add(new AclEntry.Builder().setType(AclEntryType.NAMED_USER).setSubject(TEST_USER_2.getUser()).addAction(AclAction.READ).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
            entries.add(new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(group).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
            AlluxioURI srcDir = new AlluxioURI(testDir);
            sFileSystem.setAttribute(srcDir, SetAttributePOptions.newBuilder().setRecursive(true).setOwner(owner).setGroup(group).setMode(new Mode(mode).toProto()).setPinned(true).setReplicationMin(2).setReplicationMax(4).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(12345L)).build());
            sFileSystem.setAcl(srcDir, SetAclAction.MODIFY, entries, SetAclPOptions.newBuilder().setRecursive(true).build());
            int ret = fsShell.run(new String[]{"cp", "-R", "-p", testDir, newDir});
            AlluxioURI dstDir = new AlluxioURI(newDir);
            Assert.assertEquals((long)0L, (long)ret);
            Assert.assertTrue((boolean)sFileSystem.exists(dstDir));
            this.verifyPreservedAttributes(srcDir, dstDir);
            this.verifyPreservedAttributes(srcDir.join(subDir), dstDir.join(subDir));
            this.verifyPreservedAttributes(srcDir.join(file), dstDir.join(file));
        }
    }

    private void verifyPreservedAttributes(AlluxioURI src, AlluxioURI dst) throws IOException, AlluxioException {
        URIStatus srcStatus = sFileSystem.getStatus(src);
        URIStatus dstStatus = sFileSystem.getStatus(dst);
        Assert.assertEquals((Object)srcStatus.getOwner(), (Object)dstStatus.getOwner());
        Assert.assertEquals((Object)srcStatus.getGroup(), (Object)dstStatus.getGroup());
        Assert.assertEquals((long)srcStatus.getMode(), (long)dstStatus.getMode());
        Assert.assertEquals((Object)srcStatus.getAcl(), (Object)dstStatus.getAcl());
        Assert.assertNotEquals((long)srcStatus.getTtl(), (long)dstStatus.getTtl());
        if (!srcStatus.isFolder()) {
            Assert.assertNotEquals((long)srcStatus.getReplicationMin(), (long)dstStatus.getReplicationMin());
            Assert.assertNotEquals((long)srcStatus.getReplicationMax(), (long)dstStatus.getReplicationMax());
        }
        Assert.assertNotEquals((Object)srcStatus.isPinned(), (Object)dstStatus.isPinned());
    }

    @Test
    public void copyInvalidArgs() throws Exception {
        FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", "/testDir", "/copy"});
        Assert.assertEquals((long)-1L, (long)ret);
        ret = sFsShell.run(new String[]{"cp", "-R", "/testDir", "/testDir/foobar4"});
        Assert.assertEquals((long)-1L, (long)ret);
        ret = sFsShell.run(new String[]{"cp", "-R", "/testDir/*", "/testDir/foobar4"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void copyAfterWorkersNotAvailable() throws Exception {
        File testFile = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testFile");
        testFile.delete();
        testFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(testFile);
        byte[] toWrite = BufferUtils.getIncreasingByteArray((int)100);
        fos.write(toWrite);
        fos.close();
        sFsShell.run(new String[]{"copyFromLocal", testFile.getPath(), "/"});
        Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/testFile")));
        sLocalAlluxioCluster.stopWorkers();
        sFsShell.run(new String[]{"cp", "/testFile", "/testFile2"});
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/testFile2")));
    }

    @Test
    public void copyAfterWorkersNotAvailableMustCache() throws Exception {
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, "MUST_CACHE");
        try (FileSystemShell fsShell = new FileSystemShell((AlluxioConfiguration)conf);){
            File testFile = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testFile");
            testFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(testFile);
            byte[] toWrite = BufferUtils.getIncreasingByteArray((int)100);
            fos.write(toWrite);
            fos.close();
            fsShell.run(new String[]{"copyFromLocal", testFile.getPath(), "/"});
            Assert.assertTrue((boolean)sFileSystem.exists(new AlluxioURI("/testFile")));
            sLocalAlluxioCluster.stopWorkers();
            fsShell.run(new String[]{"cp", "/testFile", "/testFile2"});
            Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/testFile2")));
        }
    }

    private boolean equals(AlluxioURI file1, AlluxioURI file2) throws Exception {
        try (Closer closer = Closer.create();){
            OpenFilePOptions openFileOptions = OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build();
            FileInStream is1 = (FileInStream)closer.register((Closeable)sFileSystem.openFile(file1, openFileOptions));
            FileInStream is2 = (FileInStream)closer.register((Closeable)sFileSystem.openFile(file2, openFileOptions));
            boolean bl = IOUtils.contentEquals((InputStream)is1, (InputStream)is2);
            return bl;
        }
    }

    @Test
    public void copyFromLocalFileToDstPath() throws Exception {
        String dataString = "copyFromLocalFileToDstPathTest";
        byte[] data = dataString.getBytes();
        File localDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/localDir");
        localDir.mkdir();
        File localFile = this.generateFileContent("/localDir/testFile", data);
        sFsShell.run(new String[]{"mkdir", "/dstDir"});
        sFsShell.run(new String[]{"cp", "file://" + localFile.getPath(), "/dstDir"});
        AlluxioURI uri = new AlluxioURI("/dstDir/testFile");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertNotNull((Object)status);
        byte[] read = this.readContent(uri, data.length);
        Assert.assertEquals((Object)new String(read), (Object)dataString);
    }

    @Test
    public void copyFromLocalDir() throws Exception {
        File srcOuterDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir");
        File srcInnerDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/innerDir");
        File emptyDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/emptyDir");
        srcOuterDir.mkdir();
        srcInnerDir.mkdir();
        emptyDir.mkdir();
        this.generateFileContent("/outerDir/srcFile1", BufferUtils.getIncreasingByteArray((int)10));
        this.generateFileContent("/outerDir/innerDir/srcFile2", BufferUtils.getIncreasingByteArray((int)10));
        int ret = sFsShell.run(new String[]{"cp", "file://" + srcOuterDir.getPath() + "/", "/dstDir"});
        Assert.assertEquals((long)0L, (long)ret);
        AlluxioURI dstURI1 = new AlluxioURI("/dstDir/srcFile1");
        AlluxioURI dstURI2 = new AlluxioURI("/dstDir/innerDir/srcFile2");
        AlluxioURI dstURI3 = new AlluxioURI("/dstDir/emptyDir");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI1));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI2));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI3));
        File srcDeepDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/srcDir0/srcDir1");
        srcDeepDir.mkdirs();
        this.generateFileContent("/srcDir0/srcDir1/srcFile3", BufferUtils.getIncreasingByteArray((int)10));
        String srcDeepDirStr = "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/srcDir0/";
        ret = sFsShell.run(new String[]{"cp", srcDeepDirStr, "/dstDir"});
        Assert.assertEquals((long)0L, (long)ret);
        AlluxioURI dstURI4 = new AlluxioURI("/dstDir/srcDir1/srcFile3");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI4));
    }

    @Test
    public void copyFromLocalDirToExistingFile() throws Exception {
        File localDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/localDir");
        File innerDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/localDir/innerDir");
        localDir.mkdir();
        innerDir.mkdir();
        this.generateFileContent("/localDir/srcFile", BufferUtils.getIncreasingByteArray((int)10));
        sFileSystem.createFile(new AlluxioURI("/dstFile")).close();
        int ret = sFsShell.run(new String[]{"cp", "file://" + localDir.getPath(), "/dstFile"});
        Assert.assertEquals((long)-1L, (long)ret);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI("/dstFile")).isFolder());
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/dstFile/innerDir")));
    }

    @Test
    public void copyFromLocalDirToExistingDir() throws Exception {
        File srcOuterDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir");
        File srcInnerDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/innerDir");
        File emptyDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/outerDir/emptyDir");
        srcOuterDir.mkdir();
        srcInnerDir.mkdir();
        emptyDir.mkdir();
        this.generateFileContent("/outerDir/srcFile1", BufferUtils.getIncreasingByteArray((int)10));
        this.generateFileContent("/outerDir/innerDir/srcFile2", BufferUtils.getIncreasingByteArray((int)10));
        sFileSystem.createDirectory(new AlluxioURI("/dstDir"));
        int ret = sFsShell.run(new String[]{"cp", "file://" + srcOuterDir.getPath(), "/dstDir"});
        Assert.assertEquals((long)0L, (long)ret);
        AlluxioURI dstURI1 = new AlluxioURI("/dstDir/srcFile1");
        AlluxioURI dstURI2 = new AlluxioURI("/dstDir/innerDir/srcFile2");
        AlluxioURI dstURI3 = new AlluxioURI("/dstDir/emptyDir");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI1));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI2));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI3));
        sFileSystem.createDirectory(new AlluxioURI("/dstDir1"));
        sFileSystem.createDirectory(new AlluxioURI("/dstDir1/innerDir"));
        int ret1 = sFsShell.run(new String[]{"cp", "file://" + srcOuterDir.getPath(), "/dstDir1"});
        Assert.assertEquals((long)-1L, (long)ret1);
        dstURI1 = new AlluxioURI("/dstDir1/srcFile1");
        dstURI2 = new AlluxioURI("/dstDir1/innerDir/srcFile2");
        dstURI3 = new AlluxioURI("/dstDir1/emptyDir");
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI1));
        Assert.assertFalse((boolean)sFileSystem.exists(dstURI2));
        Assert.assertNotNull((Object)sFileSystem.getStatus(dstURI3));
    }

    @Test
    public void copyFromLocalLarge() throws Exception {
        File testFile = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testFile");
        testFile.delete();
        testFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(testFile);
        byte[] toWrite = BufferUtils.getIncreasingByteArray((int)0x1000000);
        fos.write(toWrite);
        fos.close();
        String[] cmd = new String[]{"cp", "file://" + testFile.getAbsolutePath(), "/testFile"};
        sFsShell.run(cmd);
        Assert.assertEquals((Object)this.getCommandOutput(cmd), (Object)this.mOutput.toString());
        AlluxioURI uri = new AlluxioURI("/testFile");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((long)0x1000000L, (long)status.getLength());
        try (FileInStream tfis = sFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build());){
            byte[] read = new byte[0x1000000];
            tfis.read(read);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)0x1000000, (byte[])read));
        }
    }

    @Test
    public void copyFromLocalOverwrite() throws Exception {
        int LEN1 = 10;
        int LEN2 = 20;
        File testFile1 = this.generateFileContent("/testFile1", BufferUtils.getIncreasingByteArray((int)10));
        File testFile2 = this.generateFileContent("/testFile2", BufferUtils.getIncreasingByteArray((int)20));
        AlluxioURI alluxioFilePath = new AlluxioURI("/testFile");
        String[] cmd1 = new String[]{"cp", "file://" + testFile1.getPath(), alluxioFilePath.getPath()};
        sFsShell.run(cmd1);
        Assert.assertEquals((Object)this.getCommandOutput(cmd1), (Object)this.mOutput.toString());
        this.mOutput.reset();
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])this.readContent(alluxioFilePath, 10)));
        String[] cmd2 = new String[]{"cp", "file://" + testFile2.getPath(), alluxioFilePath.getPath()};
        Assert.assertEquals((long)-1L, (long)sFsShell.run(cmd2));
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.CANNOT_OVERWRITE_FILE_WITHOUT_OVERWRITE.getMessage(new Object[]{alluxioFilePath.getPath()})));
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])this.readContent(alluxioFilePath, 10)));
    }

    @Test
    public void copyFromLocal() throws Exception {
        File testDir = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir");
        testDir.mkdir();
        File testDirInner = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir/testDirInner");
        testDirInner.mkdir();
        File testFile = this.generateFileContent("/testDir/testFile", BufferUtils.getIncreasingByteArray((int)10));
        this.generateFileContent("/testDir/testDirInner/testFile2", BufferUtils.getIncreasingByteArray((int)10, (int)20));
        String[] cmd = new String[]{"cp", "file://" + testFile.getParent(), "/testDir"};
        sFsShell.run(cmd);
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)this.getCommandOutput(cmd)));
        AlluxioURI uri1 = new AlluxioURI("/testDir/testFile");
        AlluxioURI uri2 = new AlluxioURI("/testDir/testDirInner/testFile2");
        URIStatus status1 = sFileSystem.getStatus(uri1);
        URIStatus status2 = sFileSystem.getStatus(uri2);
        Assert.assertNotNull((Object)status1);
        Assert.assertNotNull((Object)status2);
        Assert.assertEquals((long)10L, (long)status1.getLength());
        Assert.assertEquals((long)20L, (long)status2.getLength());
        byte[] read = this.readContent(uri1, 10);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])read));
        read = this.readContent(uri2, 20);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)20, (byte[])read));
    }

    @Test
    public void copyFromLocalTestWithFullURI() throws Exception {
        File testFile = this.generateFileContent("/srcFileURI", BufferUtils.getIncreasingByteArray((int)10));
        String alluxioURI = "alluxio://" + sLocalAlluxioCluster.getHostname() + ":" + sLocalAlluxioCluster.getMasterRpcPort() + "/destFileURI";
        String[] cmd = new String[]{"cp", "file://" + testFile.getPath(), alluxioURI};
        sFsShell.run(cmd);
        String cmdOut = this.getCommandOutput(cmd);
        Assert.assertEquals((Object)cmdOut, (Object)this.mOutput.toString());
        AlluxioURI uri = new AlluxioURI("/destFileURI");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertEquals((long)10L, (long)status.getLength());
        byte[] read = this.readContent(uri, 10);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (byte[])read));
    }

    @Test
    public void copyFromLocalWildcardExistingDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"cp", "file://" + testDir + "/*/foo*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar1")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar3")));
    }

    @Test
    public void copyFromLocalWildcardHier() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        int ret = sFsShell.run(new String[]{"cp", "file://" + testDir + "/*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foo/foobar1")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foo/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/bar/foobar3")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar4")));
    }

    @Test
    public void copyFromLocalWildcardNotDir() throws Exception {
        String localTestDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        String alluxioTestDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", "file://" + localTestDir + "/*/foo*", alluxioTestDir + "/foobar4"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void copyFromLocalWildcard() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetLocalFileHierarchy(sLocalAlluxioCluster);
        int ret = sFsShell.run(new String[]{"cp", "file://" + testDir + "/*/foo*", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar1")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testDir/foobar3")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI("/testDir/foobar4")));
    }

    @Test
    public void copyToLocalDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", testDir, "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foo/foobar1", 10);
        this.fileReadTest("/testDir/foo/foobar2", 20);
        this.fileReadTest("/testDir/bar/foobar3", 30);
        this.fileReadTest("/testDir/foobar4", 40);
    }

    @Test
    public void copyToLocal() throws Exception {
        this.copyToLocalWithBytes(10);
    }

    @Test
    public void copyToLocalWildcardExistingDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir").mkdir();
        int ret = sFsShell.run(new String[]{"cp", testDir + "/*/foo*", "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foobar1", 10);
        this.fileReadTest("/testDir/foobar2", 20);
        this.fileReadTest("/testDir/foobar3", 30);
    }

    @Test
    public void copyToLocalWildcardHier() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", testDir + "/*", "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foo/foobar1", 10);
        this.fileReadTest("/testDir/foo/foobar2", 20);
        this.fileReadTest("/testDir/bar/foobar3", 30);
        this.fileReadTest("/testDir/foobar4", 40);
    }

    @Test
    public void copyToLocalWildcardNotDir() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir").mkdir();
        File testFile = new File(sLocalAlluxioCluster.getAlluxioHome() + "/testDir/testFile");
        testFile.delete();
        testFile.createNewFile();
        int ret = sFsShell.run(new String[]{"cp", testDir + "/*/foo*", "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/testDir/testFile"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void copyToLocalWildcard() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        int ret = sFsShell.run(new String[]{"cp", testDir + "/*/foo*", "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
        this.fileReadTest("/testDir/foobar1", 10);
        this.fileReadTest("/testDir/foobar2", 20);
        this.fileReadTest("/testDir/foobar3", 30);
    }

    @Override
    protected void copyToLocalWithBytes(int bytes) throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)bytes);
        String[] cmd = new String[]{"cp", "/testFile", "file://" + sLocalAlluxioCluster.getAlluxioHome() + "/testFile"};
        sFsShell.run(cmd);
        Assert.assertEquals((Object)this.getCommandOutput(cmd), (Object)this.mOutput.toString());
        this.fileReadTest("/testFile", 10);
    }
}

