/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.job.JobConfig;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.util.JobTestUtils;
import alluxio.job.wire.Status;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemFactory;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jianjian", comment="fix or remove these tests")
public final class DistributedCpCancelTest
extends AbstractFileSystemShellTest {
    private static final long SLEEP_MS = 30000L;
    private static final int TEST_TIMEOUT = 90000;
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new SleepingUnderFileSystemFactory(new SleepingUnderFileSystemOptions().setOpenMs(30000L)));
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();

    @Before
    public void before() throws Exception {
        String localUfsPath = this.mTempFolder.getRoot().getAbsolutePath();
        sFileSystem.mount(new AlluxioURI("/mnt/"), new AlluxioURI("sleep://" + localUfsPath));
        new File(localUfsPath + "/dir/").mkdirs();
        FileWriter fileWriter = new FileWriter(localUfsPath + "/dir/file");
        fileWriter.write("test");
        fileWriter.close();
    }

    @Test
    public void testDistributedCpCancelStats() throws Exception {
        long jobId = sJobMaster.run((JobConfig)new MigrateConfig("/mnt/dir/file", "/testFileDest", WriteType.THROUGH, false));
        Thread.sleep(3000L);
        sJobShell.run(new String[]{"cancel", Long.toString(jobId)});
        JobTestUtils.waitForJobStatus(sJobMaster, jobId, Sets.newHashSet((Object[])new Status[]{Status.CANCELED}), 90000);
        Assert.assertFalse((boolean)sFileSystem.exists(new AlluxioURI("/testFileDest")));
    }
}

