/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.util.io.PathUtils;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jianjian", comment="fix or remove these tests")
public final class DistributedCpCommandTest
extends AbstractFileSystemShellTest {
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();

    @Test
    public void crossMountCopy() throws Exception {
        File file = this.mFolder.newFile();
        Files.write((byte[])"hello".getBytes(), (File)file);
        this.run("mount", "/cross", this.mFolder.getRoot().getAbsolutePath());
        this.run("ls", "-f", "/cross");
        this.run("distributedCp", PathUtils.concatPath((Object)"/cross", (Object)file.getName()), "/copied");
        this.mOutput.reset();
        this.run("cat", "/copied");
        Assert.assertEquals((Object)"hello", (Object)this.mOutput.toString());
    }

    @Test
    public void crossMountCopyWithBatch() throws Exception {
        File file = this.mFolder.newFile();
        File file2 = this.mFolder.newFile();
        Files.write((byte[])"hello".getBytes(), (File)file);
        Files.write((byte[])"world".getBytes(), (File)file2);
        this.run("mount", "/cross", this.mFolder.getRoot().getAbsolutePath());
        this.run("ls", "-f", "/cross");
        this.run("distributedCp", "--batch-size", "2", "/cross", "/copied");
        this.mOutput.reset();
        this.run("cat", PathUtils.concatPath((Object)"/copied", (Object)file.getName()));
        Assert.assertEquals((Object)"hello", (Object)this.mOutput.toString());
        this.mOutput.reset();
        this.run("cat", PathUtils.concatPath((Object)"/copied", (Object)file2.getName()));
        Assert.assertEquals((Object)"world", (Object)this.mOutput.toString());
    }

    @Test
    public void crossMountCopyLotsFilesWithSmallBatchSize() throws Exception {
        int i;
        int fileSize = 100;
        ArrayList<File> files = new ArrayList<File>(fileSize);
        for (i = 0; i < fileSize; ++i) {
            File file = this.mFolder.newFile();
            String content = "hello" + i;
            Files.write((byte[])content.getBytes(), (File)file);
            files.add(file);
        }
        this.run("mount", "/cross", this.mFolder.getRoot().getAbsolutePath());
        this.run("ls", "-f", "/cross");
        this.run("distributedCp", "--batch-size", "3", "/cross", "/copied");
        for (i = 0; i < fileSize; ++i) {
            this.mOutput.reset();
            this.run("cat", PathUtils.concatPath((Object)"/copied", (Object)((File)files.get(i)).getName()));
            Assert.assertEquals((Object)("hello" + i), (Object)this.mOutput.toString());
        }
    }

    @Test
    public void crossMountCopyNestedFilesWithBatch() throws Exception {
        int i;
        int fileSize = 10;
        ArrayList<File> files = new ArrayList<File>(fileSize);
        ArrayList<File> subFolderFiles = new ArrayList<File>(fileSize);
        ArrayList<File> subSubFolderFiles = new ArrayList<File>(fileSize);
        File subDir = this.mFolder.newFolder("subFolder");
        File subSubDir = this.mFolder.newFolder(new String[]{"subFolder", "subSubFolder"});
        for (i = 0; i < fileSize; ++i) {
            File file = this.mFolder.newFile();
            String content = "hello" + i;
            Files.write((byte[])content.getBytes(), (File)file);
            files.add(file);
            file = new File(subDir, "subFile" + i);
            content = "world" + i;
            Files.write((byte[])content.getBytes(), (File)file);
            subFolderFiles.add(file);
            file = new File(subSubDir, "subSubFile" + i);
            content = "game" + i;
            Files.write((byte[])content.getBytes(), (File)file);
            subSubFolderFiles.add(file);
        }
        this.run("mount", "/cross", this.mFolder.getRoot().getAbsolutePath());
        this.run("ls", "-f", "/cross");
        this.run("distributedCp", "--batch-size", "13", "/cross", "/copied");
        for (i = 0; i < fileSize; ++i) {
            this.mOutput.reset();
            this.run("cat", PathUtils.concatPath((Object)"/copied", (Object)((File)files.get(i)).getName()));
            Assert.assertEquals((Object)("hello" + i), (Object)this.mOutput.toString());
            this.mOutput.reset();
            this.run("cat", PathUtils.concatPath((Object)"/copied", (Object[])new Object[]{subDir.getName(), ((File)subFolderFiles.get(i)).getName()}));
            Assert.assertEquals((Object)("world" + i), (Object)this.mOutput.toString());
            this.mOutput.reset();
            this.run("cat", PathUtils.concatPath((Object)"/copied", (Object[])new Object[]{subDir.getName(), subSubDir.getName(), ((File)subSubFolderFiles.get(i)).getName()}));
            Assert.assertEquals((Object)("game" + i), (Object)this.mOutput.toString());
        }
    }

    private void run(String ... args) {
        if (sFsShell.run(args) != 0) {
            throw new RuntimeException("Failed command <" + Joiner.on((String)" ").join((Object[])args) + "> " + this.mOutput.toString());
        }
    }
}

