/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractDoraFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemUtils;
import alluxio.conf.PropertyKey;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DoraLoadCommandIntegrationTest
extends AbstractDoraFileSystemShellTest {
    public DoraLoadCommandIntegrationTest() throws IOException {
        super(3);
    }

    @Override
    public void before() throws Exception {
        this.mLocalAlluxioClusterResource.setProperty(PropertyKey.JOB_BATCH_SIZE, 3);
        this.mLocalAlluxioClusterResource.setProperty(PropertyKey.MASTER_SCHEDULER_INITIAL_DELAY, "1s");
        super.before();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="yimin", comment="fix or remove this test")
    public void testCommand() throws Exception {
        this.mTestFolder.newFolder("testRoot");
        this.mTestFolder.newFolder("testRoot/testDirectory");
        this.createByteFileInUfs("/testRoot/testFileA", 0x100000);
        this.createByteFileInUfs("/testRoot/testFileB", 0x100000);
        this.createByteFileInUfs("/testRoot/testDirectory/testFileC", 0x100000);
        AlluxioURI uriA = new AlluxioURI("/testRoot/testFileA");
        AlluxioURI uriB = new AlluxioURI("/testRoot/testFileB");
        AlluxioURI uriC = new AlluxioURI("/testRoot/testDirectory/testFileC");
        Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(uriA).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(uriB).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(uriC).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)this.mFsShell.run(new String[]{"load", "/testRoot", "--submit", "--verify"}));
        Assert.assertEquals((long)0L, (long)this.mFsShell.run(new String[]{"load", "/testRoot", "--progress"}));
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uriA, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uriB, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uriC, (int)100);
        while (!this.mOutput.toString().contains("SUCCEEDED")) {
            Assert.assertEquals((long)0L, (long)this.mFsShell.run(new String[]{"load", "/testRoot", "--progress"}));
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Files Processed: 3"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Directories Processed: 1"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Bytes Loaded: 3072.00KB out of 3072.00KB"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Files Failed: 0"));
        Assert.assertEquals((long)0L, (long)this.mFsShell.run(new String[]{"load", "/testRoot", "--stop"}));
        Assert.assertEquals((long)-2L, (long)this.mFsShell.run(new String[]{"load", "/testRootNotExists", "--progress"}));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Load for path '/testRootNotExists' cannot be found."));
        this.mFsShell.run(new String[]{"load", "/testRoot", "--progress", "--format", "JSON"});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("\"mJobState\":\"SUCCEEDED\""));
        this.mFsShell.run(new String[]{"load", "/testRoot", "--progress", "--format", "JSON", "--verbose"});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("\"mVerbose\":true"));
    }
}

