/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.WritePType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="write through dora is broken")
public final class DuCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void du() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)0);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileB", (WritePType)WritePType.MUST_CACHE, (int)21243);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testFileC", (WritePType)WritePType.THROUGH, (int)9712654);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testDir/testFileD", (WritePType)WritePType.THROUGH, (int)532982);
        String expected = "";
        sFsShell.run(new String[]{"du", "/testRoot/noneExisting"});
        expected = expected + "File Size     In Alluxio       Path\n";
        expected = expected + ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"/testRoot/noneExisting"}) + "\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        this.mOutput.reset();
        sFsShell.run(new String[]{"du", "/testRoot/"});
        expected = "File Size     In Alluxio       Path\n532982        0 (0%)           /testRoot/testDir/testDir/testFileD\n9712654       0 (0%)           /testRoot/testDir/testFileC\n0             0 (0%)           /testRoot/testFileA\n21243         21243 (100%)     /testRoot/testFileB\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        this.mOutput.reset();
        sFsShell.run(new String[]{"du", "-h", "-s", "/testRoot/testDir"});
        expected = "File Size     In Alluxio       Path\n9.77MB        0B (0%)          /testRoot/testDir\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        this.mOutput.reset();
        sFsShell.run(new String[]{"du", "-h", "-s", "--memory", "/testRoot"});
        expected = "File Size     In Alluxio       In Memory        Path\n9.79MB        20.75KB (0%)     20.75KB (0%)     /testRoot\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        String workerHostName = sLocalAlluxioCluster.getWorkerAddress().getHost();
        this.mOutput.reset();
        String format = "%-13s %-16s %-25s %s";
        sFsShell.run(new String[]{"du", "-h", "-s", "-g", "/testRoot"});
        expected = "File Size     In Alluxio       Worker Host Name          Path\n9.79MB        20.75KB (0%)     total                     /testRoot\n" + String.format(format, "", "20.75KB", workerHostName, "") + "\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void duWildcard() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir1/testFileA", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir2/testFileB", (WritePType)WritePType.THROUGH, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir2/testNotIncludeFile", (WritePType)WritePType.MUST_CACHE, (int)30);
        sFsShell.run(new String[]{"du", "/testRoot/*/testFile*"});
        String expected = "File Size     In Alluxio       Path\n10            10 (100%)        /testRoot/testDir1/testFileA\n20            0 (0%)           /testRoot/testDir2/testFileB\n";
        sFsShell.run(new String[]{"du", "-h", "-s", "--memory", "/testRoot/*"});
        expected = expected + "File Size     In Alluxio       In Memory        Path\n10B           10B (100%)       10B (100%)       /testRoot/testDir1\n50B           30B (60%)        30B (60%)        /testRoot/testDir2\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }
}

