/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.Command;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.cli.fs.command.HelpCommand;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="fix or remove this test")
public final class HelpCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void helpNotExist() throws IOException {
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"help", "notExistTestCommand"}));
        String expected = "notExistTestCommand is an unknown command.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void help() throws IOException {
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"help", "help"}));
        HelpCommand cmd = new HelpCommand(FileSystemContext.create((AlluxioConfiguration)Configuration.global()));
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        HelpCommand.printCommandInfo((Command)cmd, (PrintWriter)printWriter);
        printWriter.close();
        String expected = stringWriter.toString();
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void helpAllCommand() throws IOException {
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"help"}));
        Map commands = FileSystemShellUtils.loadCommands((FileSystemContext)FileSystemContext.create((AlluxioConfiguration)Configuration.global()));
        String expected = "";
        TreeSet sortedCmds = new TreeSet(commands.keySet());
        for (String cmd : sortedCmds) {
            Command command = (Command)commands.get(cmd);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            HelpCommand.printCommandInfo((Command)command, (PrintWriter)printWriter);
            printWriter.close();
            expected = expected + stringWriter.toString() + "\n";
        }
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void helpRedundantArgs() throws IOException {
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"help", "Cat", "Chmod"}));
    }
}

